package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiSignCountDto;

/**
 * 签到服务
 */
@AdvancedFeignClient
public interface RemoteYoutuiSignService {

    /**
     * 查询用户连续签到次数
     *
     * @param consumerId 签到用户ID
     * @return
     */
    public Integer selectSignTimes(Long consumerId);

    /**
     * 用户签到逻辑
     * @param consumerId 签到用户ID
     * @return
     */
    public YoutuiSignCountDto sign(Long consumerId);
}
