package cn.com.duiba.tuia.youtui.center.api.constant.youtui;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 游戏版本
 * @author liyuanzeng 2018/7/27
 */
public enum GameVersion {

    DISTRIBUTION1(1, "1.1", "版本说明：是否继续倒计时版"),
    CHICKEN1(2, "1.3", "版本说明：分享到趣晒获取微信用户信息版"),
    EXTREME1(3, "1.0", "版本说明：极限手速 V1.0");

    private Integer gameTypeCode;
    private String version;
    private String desc;

    GameVersion(Integer gameTypeCode, String version, String desc) {
        this.gameTypeCode = gameTypeCode;
        this.version = version;
        this.desc = desc;
    }

    public Integer getGameTypeCode() {
        return gameTypeCode;
    }

    public void setGameTypeCode(Integer gameTypeCode) {
        this.gameTypeCode = gameTypeCode;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static List<GameVersion> getGameVersionMap(Integer gameTypeCode) {
        return Arrays.stream(GameVersion.values()).filter(v -> v.getGameTypeCode() == gameTypeCode).sorted((p1, p2) -> p2.getVersion().compareTo(p1.getVersion())).collect(Collectors.toList());
    }

}


