/**
 * 
 */
package cn.com.duiba.tuia.youtui.center.api.dto.req;

import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;

/**
 * 此类描述的是： 分页查询条件.
 *
 * @author: leiliang
 * @version: 2016年2月18日 上午9:48:22
 */
public class ReqPageQuery implements Serializable {

    /**序列号*/
    private static final long serialVersionUID = -3434405636455884638L;

    /** 每页10条记录. */
    public static final int PAGE_SIZE_10    = 10;

    /** 每页20条记录. */
    public static final int PAGE_SIZE_20    = 20;

    /** 每页50条记录. */
    public static final int PAGE_SIZE_50    = 50;

    /** 最大导出一万条. */
    public static final int MAX_EXPORT_SIZE = 10000;

    /** 分页导出最大导出50万条. */
    public static final int MAX_PAGE_EXPORT_SIZE = 500000;

    /** 起始记录数. */
    private Integer         rowStart        = 0;

    /** 当前页. */
    private Integer         currentPage     = 1;

    /** 每页记录数， 为-1时代表查询所有. */
    private Integer         pageSize;

    /** 排序字段(默认排序字段为：gmt_modified). */
    private String          sort;

    /** 排序方式：(升序:asc,降序：desc)默认降序. */
    private String          order           = "desc";

    /** 拼接字段查询使用*/
    private String          conditionStr;


    public Integer getRowStart() {
        return rowStart;
    }

    public void setRowStart(Integer rowStart) {
        this.rowStart = rowStart;
    }

    public Integer getCurrentPage() {
        return currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getSort() {
        return sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getOrder() {
        return order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public String getConditionStr() {
        return conditionStr;
    }

    public void setConditionStr(String conditionStr) {
        this.conditionStr = conditionStr;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public Integer calculateOffset() {
        //如果页索引或页大小为空，则返回为null
        if (null == this.currentPage || null == this.pageSize) {
            return null;
        }
        return (this.currentPage - 1) * this.pageSize;
    }

}
