package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiCyapDto;

import java.util.List;

/**
 * 内容配置接口
 */
@AdvancedFeignClient
public interface RemoteYoutuiContentService {

    /**
     * 获取所有投放内容配置
     *
     * @return
     */
    public List<YoutuiCyapDto> listAllContents();

    /**
     * 获取所有上架的投放内容配置
     *
     * @return
     */
    public List<YoutuiCyapDto> listAllPublishContents();

    /**
     * 获取所有上架的投放内容配置
     * @param contentType 内容类型
     * @param contentId 查询过的最后一个内容ID
     * @return
     */
    public List<YoutuiCyapDto> listAllPublishContentsByType(Integer contentType, Long contentId, Integer isRecommend);

    /**
     * 根据内容ID和类型查询内容投放配置
     *
     * @param cid   内容ID
     * @param ctype 内容类型
     * @return
     */
    public YoutuiCyapDto findByCidAndCType(Long cid, Integer ctype);
}
