package cn.com.duiba.tuia.youtui.center.api.util;

import cn.com.duiba.tuia.youtui.center.api.dto.consumer.UserAccountCenter;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.MissionDto;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;

/**
 * author: 胡 朋
 * github: https://github.com/xiaomoinfo
 * email : xiaomo@xiaomo.info
 * QQ    : 83387856
 * Date  : 2018/7/10 11:21
 * desc  :
 */
public class DataTool {
    private DataTool(){}

    /**
     * 除法
     * @param num1
     * @param num2
     * @return
     */
    public static Long devide(Long num1, Long num2) {
        BigDecimal bigDivisor = new BigDecimal(num1);
        BigDecimal bigDividend = new BigDecimal(num2);
        return bigDivisor.divide(bigDividend, 0, BigDecimal.ROUND_HALF_UP).longValue();
    }


    /**
     * 向map里设置值

     */
    public static void mapPut(Map<String,String> map, String value, String name) {
        if(StringUtils.isNotBlank(value)&& !Objects.equals("null",value)){
            map.put(name,value);
        }
    }


    /** 类型转换 */
    public static <R> R convert(String value, Function<String, R> funtion) {
        if (StringUtils.isBlank(value)||Objects.equals("null",value)) {
            return null;
        }
        return funtion.apply(value);
    }


    /** 类型转换 */
    public static <R> R convert(String value, Function<String, R> funtion,R defaultValue) {
        if (StringUtils.isBlank(value)||Objects.equals("null",value)) {
            return defaultValue;
        }
        return funtion.apply(value);
    }

    /** 在extInfo中获取值 */
    public static String getValueFromExtInfo(String extInfo,String key,String defaultValue){

        if(StringUtils.isBlank(extInfo)){
            return defaultValue;
        }
        JSONObject jsonObject = JSONObject.parseObject(extInfo);
        return (String)jsonObject.getOrDefault(key,defaultValue);
    }

    /**
     * 对任务进行排序
     * @param item1
     * @param item2
     * @return
     */
    public static int missionComparator(MissionDto item1,MissionDto item2){
        if(item1.getMissionGroup()<item2.getMissionGroup()){
            return -1;
        }
        if(item1.getMissionGroup()>item2.getMissionGroup()){
            return 1;
        }
        if(item1.getMissionSort()>item2.getMissionSort()){
            return 1;
        }
        if(item1.getMissionSort()<item2.getMissionSort()){
            return -1;
        }
        if(item1.getId()>item2.getId()){
            return 1;
        }
        if(item1.getId()<item2.getId()){
            return -1;
        }
        return 0;
    }

    /**
     * 判断是否是v1.2.0之后的user
     * @return
     */
    public static boolean isNewUser(UserAccountCenter userAccountCenter) {
        if(userAccountCenter ==null){
            return false;
        }
        return userAccountCenter.getMark()!=null&& userAccountCenter.getMark()>=1;
    }

    /** 是否是第一天注册 */
    public static boolean isFirstDay(UserAccountCenter account) {
        if(account==null||account.getGmtCreate()==null){
            return false;
        }
        //取明日的0点
        Calendar cal = Calendar.getInstance(Locale.CHINESE);
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.MILLISECOND, 0);
        cal.add(Calendar.DATE, 1);
        Long endTime = cal.getTime().getTime();
        //明天0点减去创建时间小于24小时则为第一日
        return endTime-account.getGmtCreate().getTime()<24*3600*1000;
    }
}
