package cn.com.duiba.tuia.youtui.center.api.util;

import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

import java.net.URI;
import java.util.Map;

public class HttpClientUtils {
    private HttpClientUtils() {
    }

    public static String doGet(String url, Map<String, String> param)  {
        String resultString = null;
        try (CloseableHttpClient httpClient = HttpClients.createDefault()) {
            URIBuilder builder = new URIBuilder(url);
            param.forEach(builder::addParameter);
            URI uri = builder.build();
            HttpGet httpGet = new HttpGet(uri);
            CloseableHttpResponse response = httpClient.execute(httpGet);
            if (response.getStatusLine().getStatusCode() == 200) {
                resultString = EntityUtils.toString(response.getEntity(), "UTF-8");
            }
            return resultString;
        } catch (Exception e) {
            // url输入错误的异常不做任何处理
            return null;
        }

    }
}
