package cn.com.duiba.tuia.youtui.center.api.dto.youtui;

import cn.com.duiba.tuia.youtui.center.api.common.BaseDto;
import cn.com.duiba.tuia.youtui.center.api.constant.FieldNameSpace;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;

/**
 * Create by yuanwei
 * at 2018/6/28 0028 下午 14:54
 */
public class YoutuiActivityManageDto extends BaseDto implements Serializable{


    /**
     *
     */
    private static final long serialVersionUID = 1019469911189459013L;

    private Long id;
    /**
     * title:活动标题.
     */
    private String title;
    /**
     * activityType:活动type.
     */
    private Integer activityType;
    /**
     * skinName:皮肤名称.
     */
    private String skinName;
    /**
     * activityTypeName:活动类型名称.
     */
    private String activityTypeName;
    /**
     * subType:皮肤type.
     */
    private String subType;
    /**
     * limitCount:参与次数限制.
     */
    private Integer limitCount;
    /**
     * limitScope:限制类型(enum:LimitType).
     */
    private String limitScope;
    /**
     * tag:标签.
     */
    private String tag;
    /**
     * isDeleted:是否删除.
     */
    private Boolean isDeleted;
    /**
     * activityPlanner:活动策划.
     */
    private String activityPlanner;
    /**
     * visionPlanner:视觉策划.
     */
    private String visionPlanner;
    /**
     * bannerUrl:活动中心banner图.
     */
    private String bannerUrl;
    /**
     * recommendUrl:活动中心推荐位.
     */
    private String recommendUrl;
    /**
     * listUrl:活动中心列表url.
     */
    private String listUrl;
    /**
     * isOpen:是否开启,0/1 开启/关闭.
     */
    private Boolean isOpen;
    /**
     * autoOffDate:自动关闭时间.
     */
    private Date autoOffDate;
    /**
     * 活动子类型
     */
    private String activitySubType;
    /**
     * 客户端副标题
     */
    private String subTitle;
    /**
     * 分享主标题
     */
    private String wxShareTitle;
    /**
     * 分享副标题
     */
    private String wxShareInfo;
    /**
     * 默认皮肤
     */
    private String skinType;
    /**
     * 客户端活动预览
     */
    private String appMaterialImg;
    /**
     * 快照分享图
     */
    private String wxShareImg;
    /**
     * 普通分享图
     */
    private String wxSnapshotImg;
    /**
     * 玩法说明图
     */
    private String appInstructionImg;
    /**
     * 玩法说明文字
     */
    private String instruction;

    private  String h5Title;

    /** 分享时用户行为，0：无需参与，1：分享时必须参与 */
    private Integer isShareJoin;

    /** 默认分享（0：默认展示；1：定制唤起） */
    private Integer isDefaultShare;

    /** 全屏展示（0：不需要；1：全屏展示） */
    private Integer isFullScreen;

    private String bigImageUrl;

    public Integer getIsShareJoin() {
        return isShareJoin;
    }

    public void setIsShareJoin(Integer isShareJoin) {
        this.isShareJoin = isShareJoin;
    }

    public Integer getIsDefaultShare() {
        return isDefaultShare;
    }

    public void setIsDefaultShare(Integer isDefaultShare) {
        this.isDefaultShare = isDefaultShare;
    }

    public Integer getIsFullScreen() {
        return isFullScreen;
    }

    public void setIsFullScreen(Integer isFullScreen) {
        this.isFullScreen = isFullScreen;
    }

    public String getBigImageUrl() {
        return bigImageUrl;
    }

    public void setBigImageUrl(String bigImageUrl) {
        this.bigImageUrl = bigImageUrl;
    }

    /**
     * 判断 tag 字段与传过来的集合是否有交集
     *
     * @param coll tag集合
     * @return boolean
     */
    public boolean containTags(Collection<String> coll) {
        if (StringUtils.isBlank(tag) || coll == null || coll.isEmpty()) {
            return false;
        }

        String tags = new StringBuilder(FieldNameSpace.COMMA).append(tag).append(FieldNameSpace.COMMA).toString();

        for (String str : coll) {
            if (tags.contains(FieldNameSpace.COMMA + str + FieldNameSpace.COMMA)) {
                return true;
            }
        }

        return false;
    }


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getActivityType() {
        return activityType;
    }

    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public String getSubType() {
        return subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public Integer getLimitCount() {
        return limitCount;
    }

    public void setLimitCount(Integer limitCount) {
        this.limitCount = limitCount;
    }

    public String getLimitScope() {
        return limitScope;
    }

    public void setLimitScope(String limitScope) {
        this.limitScope = limitScope;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public Boolean getIsDeleted() {
        return isDeleted;
    }

    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public String getActivityPlanner() {
        return activityPlanner;
    }

    public void setActivityPlanner(String activityPlanner) {
        this.activityPlanner = activityPlanner;
    }

    public String getVisionPlanner() {
        return visionPlanner;
    }

    public void setVisionPlanner(String visionPlanner) {
        this.visionPlanner = visionPlanner;
    }

    public String getSkinName() {
        return skinName;
    }

    public void setSkinName(String skinName) {
        this.skinName = skinName;
    }

    public String getActivityTypeName() {
        return activityTypeName;
    }

    public void setActivityTypeName(String activityTypeName) {
        this.activityTypeName = activityTypeName;
    }

    public String getBannerUrl() {
        return bannerUrl;
    }

    public void setBannerUrl(String bannerUrl) {
        this.bannerUrl = bannerUrl;
    }

    public String getRecommendUrl() {
        return recommendUrl;
    }

    public void setRecommendUrl(String recommendUrl) {
        this.recommendUrl = recommendUrl;
    }

    public String getListUrl() {
        return listUrl;
    }

    public void setListUrl(String listUrl) {
        this.listUrl = listUrl;
    }

    public Boolean getIsOpen() {
        return isOpen;
    }

    public void setIsOpen(Boolean isOpen) {
        this.isOpen = isOpen;
    }

    public Date getAutoOffDate() {
        return autoOffDate;
    }

    public void setAutoOffDate(Date autoOffDate) {
        this.autoOffDate = autoOffDate;
    }

    public Boolean getDeleted() {
        return isDeleted;
    }

    public void setDeleted(Boolean deleted) {
        isDeleted = deleted;
    }

    public Boolean getOpen() {
        return isOpen;
    }

    public void setOpen(Boolean open) {
        isOpen = open;
    }

    public String getActivitySubType() {
        return activitySubType;
    }

    public void setActivitySubType(String activitySubType) {
        this.activitySubType = activitySubType;
    }

    public String getSubTitle() {
        return subTitle;
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    public String getWxShareTitle() {
        return wxShareTitle;
    }

    public void setWxShareTitle(String wxShareTitle) {
        this.wxShareTitle = wxShareTitle;
    }

    public String getWxShareInfo() {
        return wxShareInfo;
    }

    public void setWxShareInfo(String wxShareInfo) {
        this.wxShareInfo = wxShareInfo;
    }

    public String getSkinType() {
        return skinType;
    }

    public void setSkinType(String skinType) {
        this.skinType = skinType;
    }

    public String getAppMaterialImg() {
        return appMaterialImg;
    }

    public void setAppMaterialImg(String appMaterialImg) {
        this.appMaterialImg = appMaterialImg;
    }

    public String getWxShareImg() {
        return wxShareImg;
    }

    public void setWxShareImg(String wxShareImg) {
        this.wxShareImg = wxShareImg;
    }

    public String getWxSnapshotImg() {
        return wxSnapshotImg;
    }

    public void setWxSnapshotImg(String wxSnapshotImg) {
        this.wxSnapshotImg = wxSnapshotImg;
    }

    public String getAppInstructionImg() {
        return appInstructionImg;
    }

    public void setAppInstructionImg(String appInstructionImg) {
        this.appInstructionImg = appInstructionImg;
    }

    public String getH5Title() {
        return h5Title;
    }

    public void setH5Title(String h5Title) {
        this.h5Title = h5Title;
    }

    public String getInstruction() {
        return instruction;
    }

    public void setInstruction(String instruction) {
        this.instruction = instruction;
    }
}
