package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.common.PageDto;
import cn.com.duiba.tuia.youtui.center.api.dto.req.YoutuiAppVersionQuery;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiAppVersionDto;

import java.util.List;


/**
 * Created by xuefeng on 2018/6/5.
 */
@AdvancedFeignClient
public interface RemoteAppVersionService {

    /**
     * 新建
     * @param dto
     * @return
     */
    int insert(YoutuiAppVersionDto dto);

    /**
     * 查询最新版本信息
     * @param dto
     * @return
     */
    YoutuiAppVersionDto selectRecent(YoutuiAppVersionDto dto);

    /**
     * 查询需要强制更新版本数
     * @param dto
     * @return
     */
    int selectForcibleCount(YoutuiAppVersionDto dto);

    /**
     * 查询渠道包列表信息
     * @param query
     * @return
     */
    List<YoutuiAppVersionDto> selectAppVersionList(YoutuiAppVersionQuery query);

    /**
     * 保存渠道包
     * @param dto
     * @return
     */
    Long saveAppVersion(YoutuiAppVersionDto dto);

    /**
     * 通过id查询渠道包详情
     * @param id
     * @return
     */
    YoutuiAppVersionDto selectAppVersionById(Long id);

    /**
     * 查询操作者记录
     * @param operator
     * @return
     */
    List<YoutuiAppVersionDto> selectAppVersionByOperator(String operator);

    /**
     * 查询数量
     * @param query
     * @return
     */
    int selectCount(YoutuiAppVersionQuery query);

    /**
     * 批量上传保存
     * @param dtos
     * @return
     */
    int batchSave(List<YoutuiAppVersionDto> dtos);

    /**
     * 查询是否存在此渠道包
     * @param channel
     * @param version
     * @param osType
     * @return
     */
    YoutuiAppVersionDto isExsitData(String channel,String version,Integer osType);
}
