package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.common.PageDto;
import cn.com.duiba.tuia.youtui.center.api.dto.game.GameHeartDto;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiGameConfigDto;

import java.util.Date;
import java.util.List;

/**
 * 游戏管理remote业务
 * @author liyuanzeng 2018/7/26
 */
@AdvancedFeignClient
public interface RemoteYoutuiGameConfigService {

    /**
     * 分页查询游戏
     * @param offset
     * @param max
     * @param id
     * @param gameTitle
     * @param gameType
     * @return
     */
    PageDto<YoutuiGameConfigDto> selectPageGameConfigList(Integer offset, Integer max, Long id, String gameTitle, Integer gameType);

    /**
     * 通过id查询游戏
     * @param id
     * @return
     */
    YoutuiGameConfigDto selectById(Long id);

    /**
     * 新增游戏
     * @param gameConfigDto
     * @return
     */
    Long insert(YoutuiGameConfigDto gameConfigDto);

    /**
     * 修改游戏
     * @param gameConfigDto
     * @return
     */
    Long update(YoutuiGameConfigDto gameConfigDto);

    /**
     * 删除游戏
     * @param id
     * @return
     */
    int deleteById(Long id);

    /**
     * ids批量查询游戏
     * @param ids
     * @return
     */
    List<YoutuiGameConfigDto> selectByIds(List<Long> ids);

    /**
     * 插入游戏的心跳
     * @param userId 用户id
     * @param gameId 游戏id
     * @param now 心跳时间
     */
    void insertGameHeart(Long userId, Long gameId, Date now);

    List<GameHeartDto> selectInactiveUser(Long gameId,Date start, Date end);
}
