package cn.com.duiba.tuia.youtui.center.api.dto.push;

import java.io.Serializable;
import java.util.Map;

/**
 * 推送的主题信息
 *
 * @author lichao 2018/8/4
 */
public class PushDto implements Serializable {

    private static final long serialVersionUID = 6103277082680308707L;
    //名称
    private String title;
    //描述
    private String content;
    //主体类型
    private Map<String, String> extra;

    //推送类型
    private PushMsgType pushMsgType;

    //主体图标
    private String lunchImage;

    //是否全量推送
    private boolean isAll;

    //是否端外推送,默认false
    private boolean outsidePush;

    public PushDto() {
    }

    public PushDto(String title, String content, Map<String, String> extra, PushMsgType pushMsgType, String lunchImage) {
        this.title = title;
        this.content = content;
        this.extra = extra;
        this.pushMsgType = pushMsgType;
        this.lunchImage = lunchImage;
    }

    public PushDto(String title) {
        this.title = title;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Map<String, String> getExtra() {
        return extra;
    }

    public void setExtra(Map<String, String> extra) {
        this.extra = extra;
    }


    public String getLunchImage() {
        return lunchImage;
    }

    public void setLunchImage(String lunchImage) {
        this.lunchImage = lunchImage;
    }

    public PushMsgType getPushMsgType() {
        return pushMsgType;
    }

    public void setPushMsgType(PushMsgType pushMsgType) {
        this.pushMsgType = pushMsgType;
    }


    public boolean isAll() {
        return isAll;
    }

    public void setAll(boolean all) {
        isAll = all;
    }

    public boolean getOutsidePush() {
        return outsidePush;
    }

    public void setOutsidePush(boolean outsidePush) {
        this.outsidePush = outsidePush;
    }
}
