package cn.com.duiba.tuia.youtui.center.api.dto.push;

import java.io.Serializable;

/**
 * url 推送给客户端打开的dto
 *
 * @author lichao 2018/8/29
 */
public class UrlPushDto implements Serializable {


    /** h5标题名称 可空 默认为空白 */
    private String taskName;

    /** 内容id 可空 有分享场景时不可空 */
    private Long contentId;

    /** 内容类型 可空 有分享场景不可空 */
    private Integer contentType;

    /** 打开页面的url 不可空 */
    private String url;

    /**h5类型 0 ->活动预览 1->默认传urlH5 2->活动预览 带url（url必须传）默认为2 */
    private int h5Type = 2;

    /**预览是否有奖 0：无奖；1：有奖 */
    private int rewardStatus;

    /** 是否需要全屏 0：不需要； 1：全屏展 */
    private int isFullScreen;

    /** pageSource(0-默认 1-banner页 2-首页列表  3-我的分享页 4-新手引导页  5-"互动页面" 6-"专栏页面 7-趣味活动页面 8-奖励中心页 9-"更多"页)
     * 默认为 0 */
    private int pageSource = 11;


    public String getTaskName() {
        return taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public Long getContentId() {
        return contentId;
    }

    public void setContentId(Long contentId) {
        this.contentId = contentId;
    }

    public Integer getContentType() {
        return contentType;
    }

    public void setContentType(Integer contentType) {
        this.contentType = contentType;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public int getH5Type() {
        return h5Type;
    }

    public void setH5Type(int h5Type) {
        this.h5Type = h5Type;
    }

    public int getRewardStatus() {
        return rewardStatus;
    }

    public void setRewardStatus(int rewardStatus) {
        this.rewardStatus = rewardStatus;
    }

    public int getIsFullScreen() {
        return isFullScreen;
    }

    public void setIsFullScreen(int isFullScreen) {
        this.isFullScreen = isFullScreen;
    }

    public int getPageSource() {
        return pageSource;
    }

    public void setPageSource(int pageSource) {
        this.pageSource = pageSource;
    }
}
