package cn.com.duiba.tuia.youtui.center.api.dto.game;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 极限手速游戏-奖励设置dto
 */
@ApiModel("极限手速游戏奖励设置")
public class ExtremeHandSpeedSetting implements Serializable {

    private static final long serialVersionUID = -8791163888565158341L;
    /**
     * 唯一标识id
     */
    @ApiModelProperty(value = "唯一标识id", dataType = "Integer")
    private Integer id;

    /**
     * 难度
     */
    @ApiModelProperty(value = "难度", dataType = "String")
    private String difficulty;

    /**
     * 奖励金额
     */
    @ApiModelProperty(value = "奖励金额", dataType = "Double")
    private Double moneyNum;

    /**
     * 奖励条件
     */
    @ApiModelProperty(value = "奖励条件", dataType = "Integer")
    private Integer condition;

    /**
     * 出奖概率
     */
    @ApiModelProperty(value = "出奖概率", dataType = "Integer")
    private Integer rewardRate;

    public ExtremeHandSpeedSetting() {
    }

    public ExtremeHandSpeedSetting(Integer id, String difficulty, Double moneyNum, Integer condition, Integer rewardRate) {
        this.id = id;
        this.difficulty = difficulty;
        this.moneyNum = moneyNum;
        this.condition = condition;
        this.rewardRate = rewardRate;
    }

    public String getDifficulty() {
        return difficulty;
    }

    public void setDifficulty(String difficulty) {
        this.difficulty = difficulty;
    }

    public Double getMoneyNum() {
        return moneyNum;
    }

    public void setMoneyNum(Double moneyNum) {
        this.moneyNum = moneyNum;
    }

    public Integer getCondition() {
        return condition;
    }

    public void setCondition(Integer condition) {
        this.condition = condition;
    }

    public Integer getRewardRate() {
        return rewardRate;
    }

    public void setRewardRate(Integer rewardRate) {
        this.rewardRate = rewardRate;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }
}
