package cn.com.duiba.tuia.youtui.center.api.dto.youtui.pdd;


import cn.com.duiba.tuia.youtui.center.api.dto.youtui.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Map;

/**
 * 拼多多商品类目Dto
 */
@ApiModel("拼多多商品类目Dto")
public class PDDGoodsCatDto extends BaseDto {

    @ApiModelProperty("类目级别")
    private Integer level;

    @ApiModelProperty("类目名称")
    private String catName;

    @ApiModelProperty("父类目ID，0时为顶级节点")
    private Long parentCatId;

    @ApiModelProperty("类目ID")
    private Long catId;

    @ApiModelProperty("是否上架，0-未上架，1-已上架")
    private Integer isPublish;

    public Integer getLevel() {
        return level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public String getCatName() {
        return catName;
    }

    public void setCatName(String catName) {
        this.catName = catName;
    }

    public Long getParentCatId() {
        return parentCatId;
    }

    public void setParentCatId(Long parentCatId) {
        this.parentCatId = parentCatId;
    }

    public Long getCatId() {
        return catId;
    }

    public void setCatId(Long catId) {
        this.catId = catId;
    }

    public Integer getIsPublish() {
        return isPublish;
    }

    public void setIsPublish(Integer isPublish) {
        this.isPublish = isPublish;
    }

    @ApiModel("类目请求参数")
    public static class PDDGoodsCatReq extends PDDBaseReq{

        @ApiModelProperty("父级类目ID")
        private Integer parent_cat_id;

        public PDDGoodsCatReq() {
            this.parent_cat_id = 0;
        }

        public PDDGoodsCatReq(Integer parent_cat_id) {
            this.parent_cat_id = parent_cat_id;
        }

        @Override
        public Map<String, String> toMap() {
            Map<String, String> paramsMap = super.toMap();
            paramsMap.put("parent_cat_id",this.getParent_cat_id().toString());
            return paramsMap;
        }

        @Override
        public String getType() {
            return "pdd.goods.cats.get";
        }

        public Integer getParent_cat_id() {
            return parent_cat_id;
        }

        public void setParent_cat_id(Integer parent_cat_id) {
            this.parent_cat_id = parent_cat_id;
        }

    }
}
