package cn.com.duiba.tuia.youtui.center.api.dto.youtui.pdd;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Map;

@ApiModel("获得拼多多商品标签列表（非商品类目cat，当前仅开放给多多客使用）")
public class PDDGoodsOptDto {

    @ApiModelProperty("类目级别")
    private Integer level;

    @ApiModelProperty("父类目ID，0时为顶级节点")
    private Integer parentOptId;

    @ApiModelProperty("类目名称")
    private String optName;

    @ApiModelProperty("类目ID")
    private Integer optId;

    public Integer getLevel() {
        return level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public Integer getParentOptId() {
        return parentOptId;
    }


    public void setParentOptId(Integer parentOptId) {
        this.parentOptId = parentOptId;
    }

    public String getOptName() {
        return optName;
    }

    public void setOptName(String optName) {
        this.optName = optName;
    }

    public Integer getOptId() {
        return optId;
    }

    public void setOptId(Integer optId) {
        this.optId = optId;
    }

    @ApiModel("非商品类目请求参数")
    public static class PDDGoodsOptReq extends PDDBaseReq{
        @ApiModelProperty("父级类目ID")
        private Integer parent_opt_id;

        public Integer getParent_opt_id() {
            return parent_opt_id;
        }

        public void setParent_opt_id(Integer parent_opt_id) {
            this.parent_opt_id = parent_opt_id;
        }

        public PDDGoodsOptReq() {
            this.parent_opt_id = 0;
        }

        public PDDGoodsOptReq(Integer parent_opt_id) {
            this.parent_opt_id = parent_opt_id;
        }

        @Override
        public String getType() {
            return "pdd.goods.opt.get";
        }

        @Override
        public Map<String, String> toMap() {
            Map<String, String> paramsMap = super.toMap();
            paramsMap.put("parent_opt_id",this.getParent_opt_id().toString());
            return paramsMap;
        }

        public static void main(String[] args) {
            PDDGoodsOptReq pddGoodsOptReq = new PDDGoodsOptReq();
            try {
                System.err.println(pddGoodsOptReq.request().toJSONString());
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

    }
}
