package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.common.PageDto;
import cn.com.duiba.tuia.youtui.center.api.dto.req.PDDGoodsQuery;
import cn.com.duiba.tuia.youtui.center.api.dto.req.PDDOrderQuery;
import cn.com.duiba.tuia.youtui.center.api.dto.req.ReqPageQuery;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.pdd.PDDGoodsCatDto;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.pdd.PDDGoodsDto;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.pdd.PDDOrderDto;

/**
 * Create by yuanwei
 * at 2018/9/12 0012 上午 10:44
 */
@AdvancedFeignClient
public interface RemotePDDManagerService {
    /**
     * 获取拼多多商品类目列表
     * @return
     */
    PageDto<PDDGoodsCatDto> getPddGoodsCats(ReqPageQuery query);

    /**
     * 获取拼多多商品列表
     * @param query
     * @return
     */
    PageDto<PDDGoodsDto> getPddGoods(PDDGoodsQuery query);

    /**
     * 获取拼多多订单列表
     * @param query
     * @return
     */
    PageDto<PDDOrderDto> getPddOrders(PDDOrderQuery query);

    /**
     * 修改商品类目上下架
     * @param id
     * @param isPublish
     * @return
     */
    Boolean updateGoodsCatIsPublish(Long id,Integer isPublish);

    /**
     * 修改商品上下架
     * @param id
     * @param isPublish
     * @return
     */
    Boolean updateGoodsIsPublish(Long id,Integer isPublish);

    /**
     * 修改商品权重
     * @param id
     * @param rate
     * @return
     */
    Boolean updateGoodsRate(Long id,Integer rate);
}
