package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.common.PageDto;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiGameConfigDto;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiMessageCenterDto;

import java.util.List;

/**
 * 消息中心remote业务
 * @author liyuanzeng 2018/8/29
 */
@AdvancedFeignClient
public interface RemoteYoutuiMessageCenterService {

    /**
     * 分页查询
     * @param offset
     * @param max
     * @param id
     * @param title
     * @param pushStatus
     * @return
     */
    PageDto<YoutuiMessageCenterDto> selectPageList(Integer offset, Integer max, Long id, String title, Integer relationStatus, Integer pushStatus, Integer messageStatus);

    /**
     * 通过id查询
     * @param id
     * @return
     */
    YoutuiMessageCenterDto selectById(Long id);

    /**
     * 新增
     * @param dto
     * @return
     */
    Long insert(YoutuiMessageCenterDto dto);

    /**
     * 修改
     * @param dto
     * @return
     */
    Long update(YoutuiMessageCenterDto dto);

    /**
     * 删除
     * @param id
     * @return
     */
    int deleteById(Long id);

    /**
     * ids批量查询
     * @param ids
     * @return
     */
    List<YoutuiMessageCenterDto> selectByIds(List<Long> ids);

    /**
     * app消息中心查询
     * @param start
     * @param pageSize
     * @return
     */
    List<YoutuiMessageCenterDto> listByParam4app(int start,int pageSize);
}
