/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.youtui.center.api.util;

import cn.com.duiba.tuia.youtui.center.api.dto.youtui.BaseRatioDto;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class RandomFlowUtil {
    public static <T> T random4List(List<T> list) {
        if (list == null) {
            return null;
        }
        int size = list.size();
        if (size == 0) {
            return null;
        }
        int index = new Random().nextInt(size);
        return list.get(index);
    }

    public static int randomInHundred() {
        return new Random().nextInt(100);
    }

    public static boolean randomPer(int per) {
        int random = RandomFlowUtil.randomInHundred();
        return random <= per;
    }

    public static boolean randomPer(int min, int max) {
        int random = new Random().nextInt(100);
        return RandomFlowUtil.randomPer(random, min, max);
    }

    public static boolean randomPer(int per, int min, int max) {
        return per <= max && per > min;
    }

    public static boolean randomPerById(Long id, int min, int max) {
        Integer per = RandomFlowUtil.computePerWithId(id);
        return per <= max && per > min;
    }

    public static Integer computePerWithId(Long id) {
        if (id == null) {
            return 0;
        }
        return Long.valueOf(id % 99L).intValue();
    }

    public static <T extends BaseRatioDto> Integer computeIndexById(Long id, List<T> baseRatioDtos) {
        List<RatioTarget> ratioTargets = RandomFlowUtil.init(baseRatioDtos);
        Integer per = RandomFlowUtil.computePerWithId(id);
        for (RatioTarget rt : ratioTargets) {
            if (!RandomFlowUtil.randomPer(per, rt.head.getRatio(), rt.getRatio())) continue;
            return rt.getIndex();
        }
        return new Random().nextInt(baseRatioDtos.size());
    }

    public static <T extends BaseRatioDto> Integer computeIndex(List<T> baseRatioDtos) {
        List<RatioTarget> ratioTargets = RandomFlowUtil.init(baseRatioDtos);
        int random = RandomFlowUtil.randomInHundred();
        for (RatioTarget rt : ratioTargets) {
            if (!RandomFlowUtil.randomPer(random, rt.head.getRatio(), rt.getRatio())) continue;
            return rt.getIndex();
        }
        return new Random().nextInt(baseRatioDtos.size());
    }

    public static <T extends BaseRatioDto> List<RatioTarget> init(List<T> list) {
        if (list == null) {
            return null;
        }
        ArrayList listCopy = Lists.newArrayList(list);
        if (listCopy.size() > 1) {
            listCopy.sort(BaseRatioDto::compare);
        }
        ArrayList ratioTargets = Lists.newArrayList();
        Integer count = 0;
        for (BaseRatioDto dto : listCopy) {
            count = count + dto.getRatio();
        }
        for (int i = 0; i < listCopy.size(); ++i) {
            BaseRatioDto ratioDto = (BaseRatioDto)listCopy.get(i);
            if (i == 0) {
                RatioTarget ratioTarget = new RatioTarget(new RatioTarget(0), i, ratioDto.getRatio() * 100 / count);
                ratioTargets.add(ratioTarget);
                continue;
            }
            RatioTarget head = (RatioTarget)ratioTargets.get(i - 1);
            RatioTarget ratioTarget = new RatioTarget(head, i, head.getRatio() * 100 / count + ratioDto.getRatio() * 100 / count);
            ratioTargets.add(ratioTarget);
        }
        return ratioTargets;
    }

    public static void main(String[] args) {
        ArrayList list = Lists.newArrayList();
        BaseRatioDto baseRatioDto1 = new BaseRatioDto();
        baseRatioDto1.setIndex(1);
        baseRatioDto1.setRatio(10);
        list.add(baseRatioDto1);
        BaseRatioDto baseRatioDto2 = new BaseRatioDto();
        baseRatioDto2.setIndex(2);
        baseRatioDto2.setRatio(30);
        list.add(baseRatioDto2);
        BaseRatioDto baseRatioDto3 = new BaseRatioDto();
        baseRatioDto3.setIndex(3);
        baseRatioDto3.setRatio(60);
        list.add(baseRatioDto3);
        System.err.println(JSON.toJSONString(RandomFlowUtil.init(list)));
    }

    public static class RatioTarget {
        private RatioTarget head;
        private Integer index;
        private Integer ratio;

        public RatioTarget() {
        }

        public RatioTarget(Integer ratio) {
            this.ratio = ratio;
        }

        public RatioTarget(RatioTarget head, Integer index, Integer ratio) {
            this.head = head;
            this.index = index;
            this.ratio = ratio;
        }

        public Integer getIndex() {
            return this.index;
        }

        public void setIndex(Integer index) {
            this.index = index;
        }

        public Integer getRatio() {
            return this.ratio;
        }

        public void setRatio(Integer ratio) {
            this.ratio = ratio;
        }
    }
}

