package cn.com.duiba.tuia.youtui.center.api.dto.youtui.pdd;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;

/**
 * Create by yuanwei
 * at 2018/9/11 0011 下午 14:56
 */
@ApiModel("拼多多订单Dto")
public class PDDOrderDto implements Serializable {

    @ApiModelProperty(value = "主键id")
    private Long id;

    @ApiModelProperty(value = "订单编号")
    private String orderSn;

    @ApiModelProperty(value = "商品id")
    private Long goodsId;

    @ApiModelProperty(value = "商品名称")
    private String goodsName;

    @ApiModelProperty(value = "商品缩略图")
    private String goodsThumbnailUrl;

    @ApiModelProperty(value = "商品数量")
    private Long goodsQuantity;

    @ApiModelProperty(value = "商品价格（分）")
    private Long goodsPrice;

    @ApiModelProperty(value = "订单价格（分）")
    private Long orderAmount;

    @ApiModelProperty(value = "佣金比例 千分比")
    private String promotionRate;

    @ApiModelProperty(value = "佣金（分）")
    private Long promotionAmount;

    @ApiModelProperty(value = "结算批次号")
    private Long batchNo;

    @ApiModelProperty(value = "订单状态")
    private Integer orderStatus;

    @ApiModelProperty(value = "订单状态描述（ -1 未支付; 0-已支付；1-已成团；2-确认收货；3-审核成功；4-审核失败（不可提现）；5-已经结算；8-非多多进宝商品（无佣金订单）;10-已处罚）")
    private String orderStatusDesc;

    @ApiModelProperty(value = "订单创建时间（UNIX时间戳）")
    private Long orderCreateTime;

    @ApiModelProperty(value = "订单支付时间（UNIX时间戳）")
    private Long orderPayTime;

    @ApiModelProperty(value = "订单成团时间（UNIX时间戳）")
    private Long orderGroupSuccessTime;

    @ApiModelProperty(value = "订单确认收货时间（UNIX时间戳）")
    private Long orderReceiveTime;

    @ApiModelProperty(value = "订单审核时间（UNIX时间戳）")
    private Long orderVerifyTime;

    @ApiModelProperty(value = "订单结算时间（UNIX时间戳）")
    private Long orderSettleTime;

    @ApiModelProperty(value = "订单最后更新时间（UNIX时间戳）")
    private Long orderModifyAt;

    @ApiModelProperty(value = "订单来源 ：0 ：关联，5 ：直接下单页RPC请求")
    private Integer matchChannel;

    @ApiModelProperty(value = "订单类型：0：领券页面， 1： 红包页， 2：领券页， 3： 题页")
    private String type;

    @ApiModelProperty(value = "成团编号")
    private String groupId;

    @ApiModelProperty(value = "多多客工具id")
    private String authDuoId;

    @ApiModelProperty(value = "招商多多客id")
    private String zsDuoId;

    @ApiModelProperty(value = "自定义参数(userID)")
    private String customParameters;

    @ApiModelProperty(value = "CPS_Sign")
    private String cpsSign;

    @ApiModelProperty(value = "链接最后一次生产时间")
    private Long urlLastGenerateTime;

    @ApiModelProperty(value = "打点时间")
    private Long pointTime;

    @ApiModelProperty(value = "售后状态：0：无，1：售后中，2：售后完成")
    private String returnStatus;

    @ApiModelProperty(value = "推广位id")
    private String pid;

    @ApiModelProperty(value = "记录创建时间")
    private Date gmtCreate;

    @ApiModelProperty(value = "记录修改时间")
    private Date gmtModified;

    @ApiModelProperty(value = "用户id")
    private Long userId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getOrderSn() {
        return orderSn;
    }

    public void setOrderSn(String orderSn) {
        this.orderSn = orderSn;
    }

    public Long getGoodsId() {
        return goodsId;
    }

    public void setGoodsId(Long goodsId) {
        this.goodsId = goodsId;
    }

    public String getGoodsName() {
        return goodsName;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public String getGoodsThumbnailUrl() {
        return goodsThumbnailUrl;
    }

    public void setGoodsThumbnailUrl(String goodsThumbnailUrl) {
        this.goodsThumbnailUrl = goodsThumbnailUrl;
    }

    public Long getGoodsQuantity() {
        return goodsQuantity;
    }

    public void setGoodsQuantity(Long goodsQuantity) {
        this.goodsQuantity = goodsQuantity;
    }

    public Long getGoodsPrice() {
        return goodsPrice;
    }

    public void setGoodsPrice(Long goodsPrice) {
        this.goodsPrice = goodsPrice;
    }

    public Long getOrderAmount() {
        return orderAmount;
    }

    public void setOrderAmount(Long orderAmount) {
        this.orderAmount = orderAmount;
    }

    public String getPromotionRate() {
        return promotionRate;
    }

    public void setPromotionRate(String promotionRate) {
        this.promotionRate = promotionRate;
    }

    public Long getPromotionAmount() {
        return promotionAmount;
    }

    public void setPromotionAmount(Long promotionAmount) {
        this.promotionAmount = promotionAmount;
    }

    public Long getBatchNo() {
        return batchNo;
    }

    public void setBatchNo(Long batchNo) {
        this.batchNo = batchNo;
    }

    public Integer getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(Integer orderStatus) {
        this.orderStatus = orderStatus;
    }

    public String getOrderStatusDesc() {
        return orderStatusDesc;
    }

    public void setOrderStatusDesc(String orderStatusDesc) {
        this.orderStatusDesc = orderStatusDesc;
    }

    public Long getOrderCreateTime() {
        return orderCreateTime;
    }

    public void setOrderCreateTime(Long orderCreateTime) {
        this.orderCreateTime = orderCreateTime;
    }

    public Long getOrderPayTime() {
        return orderPayTime;
    }

    public void setOrderPayTime(Long orderPayTime) {
        this.orderPayTime = orderPayTime;
    }

    public Long getOrderGroupSuccessTime() {
        return orderGroupSuccessTime;
    }

    public void setOrderGroupSuccessTime(Long orderGroupSuccessTime) {
        this.orderGroupSuccessTime = orderGroupSuccessTime;
    }

    public Long getOrderReceiveTime() {
        return orderReceiveTime;
    }

    public void setOrderReceiveTime(Long orderReceiveTime) {
        this.orderReceiveTime = orderReceiveTime;
    }

    public Long getOrderVerifyTime() {
        return orderVerifyTime;
    }

    public void setOrderVerifyTime(Long orderVerifyTime) {
        this.orderVerifyTime = orderVerifyTime;
    }

    public Long getOrderSettleTime() {
        return orderSettleTime;
    }

    public void setOrderSettleTime(Long orderSettleTime) {
        this.orderSettleTime = orderSettleTime;
    }

    public Long getOrderModifyAt() {
        return orderModifyAt;
    }

    public void setOrderModifyAt(Long orderModifyAt) {
        this.orderModifyAt = orderModifyAt;
    }

    public Integer getMatchChannel() {
        return matchChannel;
    }

    public void setMatchChannel(Integer matchChannel) {
        this.matchChannel = matchChannel;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getGroupId() {
        return groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getAuthDuoId() {
        return authDuoId;
    }

    public void setAuthDuoId(String authDuoId) {
        this.authDuoId = authDuoId;
    }

    public String getZsDuoId() {
        return zsDuoId;
    }

    public void setZsDuoId(String zsDuoId) {
        this.zsDuoId = zsDuoId;
    }

    public String getCustomParameters() {
        return customParameters;
    }

    public void setCustomParameters(String customParameters) {
        this.customParameters = customParameters;
    }

    public String getCpsSign() {
        return cpsSign;
    }

    public void setCpsSign(String cpsSign) {
        this.cpsSign = cpsSign;
    }

    public Long getUrlLastGenerateTime() {
        return urlLastGenerateTime;
    }

    public void setUrlLastGenerateTime(Long urlLastGenerateTime) {
        this.urlLastGenerateTime = urlLastGenerateTime;
    }

    public Long getPointTime() {
        return pointTime;
    }

    public void setPointTime(Long pointTime) {
        this.pointTime = pointTime;
    }

    public String getReturnStatus() {
        return returnStatus;
    }

    public void setReturnStatus(String returnStatus) {
        this.returnStatus = returnStatus;
    }

    public String getPid() {
        return pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

@ApiModel("多多可拉新账单请求参数")
public static class PDDOrderReq extends PDDBaseReq{
    private String orderSn;

    public String getOrderSn() {
        return orderSn;
    }

    public void setOrderSn(String orderSn) {
        this.orderSn = orderSn;
    }

    public PDDOrderReq(String orderSn) {
        this.orderSn = orderSn;
    }
    public PDDOrderReq() {

    }

    @Override
    public String getType() {
        return "pdd.ddk.order.detail.get";
    }
    public Map<String, String> toMap(){
        Map<String, String> paramsMap = super.toMap();
        paramsMap.put("order_sn",this.getOrderSn().toString());
        return paramsMap;
    }

    public static void main(String[] args) {
        PDDOrderReq pddOrderReq = new PDDOrderReq();
        pddOrderReq.setOrderSn("180919-516128768933464");
        try {
            System.err.println(pddOrderReq.request().toString());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}














}
