package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.common.PageDto;
import cn.com.duiba.tuia.youtui.center.api.dto.req.YoutuiNationalDayBlessingQuery;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiNationalDayBlessingDto;

/**
 * 国庆祝福 用户分享记录 Remote
 *
 * @author lifuquan
 */
@AdvancedFeignClient
public interface RemoteNationalDayBlessingService {

    /**
     * 创建用户祝福分享记录
     *
     * @param record
     * @return
     */
    Long create(YoutuiNationalDayBlessingDto record);

    /**
     * 根据id查询用户祝福分享记录
     *
     * @param id
     * @return
     */
    YoutuiNationalDayBlessingDto getById(Long id);

    /**
     * 获取分享记录列表
     *
     * @return
     */
    PageDto<YoutuiNationalDayBlessingDto> getList(YoutuiNationalDayBlessingQuery blessingQuery);
}
