package cn.com.duiba.tuia.youtui.center.api.util;

import com.google.common.collect.Lists;

import java.io.Serializable;
import java.util.List;

/**
 * 签到关键字util
 */
public class SignKeywordUtil {

    public static List<SignKeyword> keywords = Lists.newArrayList();

    static {
        //TODO init keywords
        keywords.add(new SignKeyword("转运", "你将会出现大的转机，一改当前的状态，翻身得富贵。", "网络"));
        keywords.add(new SignKeyword("爱情", "真爱至上，而你恰好就在身旁。", "网络"));
        keywords.add(new SignKeyword("休假", "过于疲惫的时间太久了，抓住这个夏天的尾巴放松一下吧。", "网络"));
        keywords.add(new SignKeyword("学习", "你将迎来好的机遇，所以需要补充新的知识来提升自己。", "网络"));
        keywords.add(new SignKeyword("拼搏", "你在事业、财运或者感情方面，只要努力，就会有不错的收获。", "网络"));
        keywords.add(new SignKeyword("发财", "九月财神上门，贵人连连，发横财中大奖一夜暴富，财运无比亨通。", "网络"));
        keywords.add(new SignKeyword("选择", "命运不是运气，而是选择，舍弃不一定是失去，而是另一种更宽阔的拥有。", "网络"));
        keywords.add(new SignKeyword("开工", "她不想看到他们，看到自己的悲伤映射在他们脸上，就像是看着一面残酷的哈哈镜。\t乔伊斯·卡罗尔·奥茨《玉米少女》高谈阔论\t相信你的十四行诗比政治家们和君主们的讲话更有价值。相信你的十四行诗比政治家们和君主们的讲话更无价值。", "丹尼洛·契斯《给青年作家的忠告》"));
        keywords.add(new SignKeyword("冷静", "很多事情并不是你以为的那样，冲动是魔鬼，学会冷静，也是一种智慧。", "网络"));
        keywords.add(new SignKeyword("取舍", "欲求有得，先学施舍。取舍不仅是一种生活的哲学，也是一门生存的艺术。", "网络"));
        keywords.add(new SignKeyword("改变", "要让事情改变，先改变我自己；要让事情变得更好，先让自己变得更好。", "网络"));
        keywords.add(new SignKeyword("追索真相", "我不是多怕死，我是不想这么活。", "网络"));
        keywords.add(new SignKeyword("新生", "念旧是为了弃旧。", "苏珊·桑塔格"));
        keywords.add(new SignKeyword("清醒", "生命里有这样一个空间，我以前经常把它称为在零和一之间，然后就是一团漫长的迷局。", "《在零和一之间》"));
        keywords.add(new SignKeyword("在路上", "真正的行者本无目的可言，没有目的才是无上的行者。", "高行健《灵山》"));
        keywords.add(new SignKeyword("秉烛夜话", "夜晚，摩天大楼熠熠生辉的外表上切割出一个个灯火电量的小方块，让你将其简单归结为生命的自我消解，个故事熄灭而另一个亮了起来。", "彼得·布鲁克《时间之线》"));
        keywords.add(new SignKeyword("守护", "如果夜空里只剩下紫外线，多数的星星就不见了，只剩下恒星壮丽的诞生和毁灭的图景。", "《万物理论》"));
        keywords.add(new SignKeyword("低调", "动物的块头越大，在我们这个世界上就越容易受伤害。", "《暴风雪》"));
        keywords.add(new SignKeyword("淡然", "在夜里看起来，完美无瑕、合于理想的东西，到了白天，就变成了或多或少带有缺陷的现实之物了。", "《无名的裘德》"));
        keywords.add(new SignKeyword("自信", "身处果壳之中，也幻想自己是无限宇宙之王。", "杰克·伦敦"));
        keywords.add(new SignKeyword("酒吧长谈", "他们好像在我的DNA中安营扎寨，等待着被人聆听。", "塞巴斯蒂安·巴里"));
        keywords.add(new SignKeyword("知足", "他说：我主要是只想世界的辉煌，再把这些辉煌乘以二。,如果我有精力，就乘以十或者十二。,但是对于我，二就足以达到我的目的了。", "玛里琳·鲁宾逊《基列家书》"));
        keywords.add(new SignKeyword("钟情", "保利娜对我说：我喜欢蓝颜色，喜欢葡萄，喜欢冰凌，喜欢玫瑰花，喜欢白色的骏马。,于是我意识到我的幸福已经开始了。", "比奥伊·卡萨雷斯"));
        keywords.add(new SignKeyword("童心", "儿童的无知和轻率于是创造了一个半隐半现的世界。,也许正是由于这个原因，它带着如此鲜亮的色彩留存在记忆中。", "内米洛夫斯基《星期天》"));
        keywords.add(new SignKeyword("创想", "我工作的绝大部分旨在创造一种强大而稳定的幻想。", "《与狼共舞》"));
        keywords.add(new SignKeyword("躲闪", "经历每一个时刻都打开个更广大、更宽阔的地平线，这地平线只有去经历，它是无法逃避的。", "亨利·米勒《黑色的春天》"));
        keywords.add(new SignKeyword("晚安", "黑夜蕴藏着许多非凡的时刻，在睡梦中度过，常常是一种浪费。", "迈克尔·翁达杰《遥望》"));
        keywords.add(new SignKeyword("入眠", "花环会变黑，地壳板块会移动，深层洋流会涌动，岛屿会消失，房间会被遗忘。,你必须感受潮水的变化。,你必须与变化相随。", "琼·狄迪恩《奇想之年》"));
        keywords.add(new SignKeyword("凝视", "你应该能透过眼睛看见灵魂，透过眼睛看见爱才是，这是你可以看清别人真意的唯一处所。", "《天才雷普利》"));
        keywords.add(new SignKeyword("还乡", "他们望着海，似乎这里是万物的咸涩边缘。,	罗伯特·麦克法伦《荒野之境》"));
        keywords.add(new SignKeyword("抵达", "移动的并不是你。,是黑暗。,当你顺洋洋的，半梦半醒，在大密封舱里，黑暗冲撞过去了。", "沃伦《达科他州上空的不朽》"));
        keywords.add(new SignKeyword("守望", "我想要永恒之夜的千只眼睛，以便独独观赏你。", "玛格丽特·尤瑟纳尔"));
        keywords.add(new SignKeyword("盈满", "仅仅是生活的瞬间却希望它成为生活的结论，仅仅是在离去却期待它懂得世界的本质，爱的夜晚如此有野心。", "安娜·申切斯卡《第一首情歌》"));
        keywords.add(new SignKeyword("对酒", "闲愁如飞雪，入酒即消融。,花好如故人，一笑杯自空。", "陆游"));
        keywords.add(new SignKeyword("辞旧", "烛影摇红焰尚明，寒深知己积琼英。,老夫冒冷披衣起，要听雄鸡第一声。", "赵翼"));
        keywords.add(new SignKeyword("迎新", "以往的全部岁月，其意义就在于为了这短暂几天而等待；今后的漫长生涯，将是为这片刻的光阴而回味。", "叶芝"));
        keywords.add(new SignKeyword("串门", "过完了这个月，我们打开门，一些花开在高高的树上。,一些果结在深深的地下。", "海子"));
        keywords.add(new SignKeyword("晒太阳", "在这五光十色的世界里我要的只是公园里的一把长椅。", "埃迪特·索德格朗《礼物》"));
        keywords.add(new SignKeyword("惜时", "甚至一个短暂的瞬间也拥有丰腴的过去，我为自己分分秒秒疏漏万物向时间致歉。", "维斯瓦娃·辛波丝卡"));
        keywords.add(new SignKeyword("十指紧扣", "她的陪伴就像是热带植物周遭的热土。", "詹姆斯·乔伊斯《都柏林人》"));
        keywords.add(new SignKeyword("苏醒", "生活是种律动，须有光有影，有左有右，有晴有雨，滋味就含在这变而不猛的曲折里。", "老舍"));
        keywords.add(new SignKeyword("御风而行", "风停之后再扬帆，船绝不会前行。", "东野圭吾《分身》"));
        keywords.add(new SignKeyword("自信", "每一个灵魂是一个世界，没有窗户。,而可爱的灵魂都是倔强的独语者。", "何其芳《独语》"));
        keywords.add(new SignKeyword("心安理得", "我们一定要安详地/对心爱的谈起爱/我们一定要从容地/向光荣者说到光荣。", "骆一禾"));
        keywords.add(new SignKeyword("隐忍", "耐心和持久胜过激烈和狂热。,不管环境变换到何种地步，只有初衷与希望永不改变的人，才能最终克服困难，达到目的。", "《海底两万里》"));
        keywords.add(new SignKeyword("自省", "镜子是骄傲的酿造器，同时也是自满的消毒器。", "夏目漱石"));
        keywords.add(new SignKeyword("放歌", "大雪落在我锈迹斑斑的气管和肺叶上，今夜，我的嗓音是一列被截停的火车。", "帕斯捷尔纳克《致茨维塔耶娃》"));
        keywords.add(new SignKeyword("玩闹", "月华灯影光相射。,还是元宵也。,绮罗如画，笙歌递响，无限风雅。,闹蛾斜插，轻衫乍试，闲趁尖耍。,百年三万六千夜，愿长如今夜。", "杨无咎《人月圆》"));
        keywords.add(new SignKeyword("梦中情人", "一场幽梦同谁近，千古情人独我痴。", "曹雪芹《红楼梦》"));
        keywords.add(new SignKeyword("甄选", "戒指或宝石并不是礼物，是作为礼物的一种权宜之物。", "艾默生"));
        keywords.add(new SignKeyword("真情", "从前的锁也好看，钥匙精美有样子，你锁了人家就懂了。", "木心《从前慢》"));
        keywords.add(new SignKeyword("怡然自得", "我奇妙的玫瑰色人生，借助于一种气象现象而披上了奇异的光芒。,即使没有爱情，人生也可以是玫瑰色的。,没有恋爱却像恋爱中的人儿一样快乐，我认为这非常非常妙。", "森茉莉《我的美的世界》"));
        keywords.add(new SignKeyword("春暖花开", "冬天从这里夺去的，春天会交还给你。", "海涅"));
        keywords.add(new SignKeyword("旁观", "观察力的意义在于判断，为了判断，人必须置身于外，而不是在那里创造什么。", "克瑙斯高《我的奋斗》"));
        keywords.add(new SignKeyword("有小金库", "尽最大的可能保护私有财产，肯定是人类社会延续最为重要的必要条件。", "哈耶克《致命的自负》"));
        keywords.add(new SignKeyword("饕餮", "谁想得到肉，那他也得啃骨头。", "理查德·瓦格纳《我的生平—瓦格纳回忆录》"));
        keywords.add(new SignKeyword("懒惰", "什么事也不做，是世界上最困难的事。,不仅困难，而且非常需要智慧。", "恩里克·比拉马塔斯《巴托比症侯群》"));
        keywords.add(new SignKeyword("意外", "我们准备着深深地领受那些意想到的奇迹，在漫长的岁月里忽然有彗星的出现，狂风乍起。", "冯至《十四行诗》"));
        keywords.add(new SignKeyword("大音希声", "听到的声音很美，那听不到的声音更美。", "约翰·济慈"));
        keywords.add(new SignKeyword("自我", "不降志，不屈身，不追赶时髦，也不回避危险。", "胡适"));
        keywords.add(new SignKeyword("呵护", "人，归根结底，是一个物质存在，很容易损伤，却不容易修复。", "伊恩·麦克尤恩《赎罪》"));
        keywords.add(new SignKeyword("批评", "在犯有很多更大的错误的时代，对小错误的批评也不失其价值。", "罗伯特·木其尔"));
        keywords.add(new SignKeyword("坦荡", "诡计其实就是一种魔术手法。,一旦揭穿，真相是非常简单、稚气的。", "江户川乱步《幻影城主》"));
        keywords.add(new SignKeyword("夜行", "今夜，我的嗓音是一列被截停的火车，你的名字是俄罗斯漫长的国境线。", "茨维塔耶娃"));
        keywords.add(new SignKeyword("藏形匿影", "你隐没在梦中，宛如雪化在火中。", "阿尔蒂尔·兰波"));
        keywords.add(new SignKeyword("服从", "人类本性并不是一个你能够永远驯养的动物，一旦被驯养，它就会神智错乱。", "戴维·赫伯特·劳伦斯"));
        keywords.add(new SignKeyword("沉眠", "千百万年以后，厚重的云朵和厚重的眼袋都将合二为一。", "耶胡达·阿米亥"));
        keywords.add(new SignKeyword("白日梦", "在月光下，他常常偎着那座石像做着同一个梦—里面有湖、有山、还有松子飘落的声音。", "白先勇"));
        keywords.add(new SignKeyword("步履不停", "有如走路的速度，漫步日常风景。", "是枝裕和"));
        keywords.add(new SignKeyword("以史为鉴", "我们之所以研究历史，不是为了要知道未来，而是要拓展视野，要了解现在的种种绝非自然，也并非无可避免。", "尤瓦尔·赫拉利"));
        keywords.add(new SignKeyword("追忆往昔", "我们曾经按下的快门，就像放了数十年后的印书纸一样纤薄易碎，是我们追问或想像照片背后的故事让它有了骨骼。,它挽救、停留、无能为力却又像是阻挡了稍纵即逝的什么。", "吴明益"));
        keywords.add(new SignKeyword("醉春风", "澄明的空气里波动着的远远的蜂声，绝似诱人入睡的慈母的歌唱，这正是村人野老欲伸腰偷懒的时候，这也是青年男女为情舍命的时候。", "郁达夫"));
        keywords.add(new SignKeyword("携手相随", "生活教会我们，爱不是两个人互相凝视对方，而是两个人看向外界同一个方向。", "安东尼．德．圣—埃克苏佩里"));
        keywords.add(new SignKeyword("自爱", "自爱者方能为人所爱。", "蒙田"));
        keywords.add(new SignKeyword("坚韧", "后来，我时常在想，我们是怎么度过那些年月而没有垮掉？也许体格和情感的耐力基本上是一个习惯问题，不管我们缺少什么，我们不会缺少在危机时期考验我们的机会。", "果尔达·梅厄"));
        keywords.add(new SignKeyword("加班", "无事可做就像被绑架了，使你成为生活的奴隶。", "安迪·沃霍尔"));
        keywords.add(new SignKeyword("一夜好眠", "睡眠对于他来说不是生命的反义词，睡眠对他来说就是生命，生命就是一种梦。,他从一个梦转到另一个梦，就好像从此生命到彼生命。", "米兰昆德拉"));
        keywords.add(new SignKeyword("拥抱明天", "过去属于死神，未来属于你自己。", "雪莱"));
        keywords.add(new SignKeyword("做个幸福的人", "陌生人，我也为你祝福；愿你有一个灿烂的前程；愿你有情人终成眷属；愿你在尘世获得幸福。", "海子"));
        keywords.add(new SignKeyword("食酒", "酒和食物都是我非常喜爱的，我觉得食物其实和建筑有着很相似的地方，经常能够从中得到各种灵感。", "隈研吾"));

    }

    public static SignKeyword getByKey(String key) {
        int i = Math.abs(key.hashCode());
        int i1 = i % keywords.size();
        return keywords.get(i1);
    }

    public static class SignKeyword implements Serializable {
        private String keyword;

        private String text;

        private String source;

        public SignKeyword() {
        }

        public SignKeyword(String keyword, String text) {
            this.keyword = keyword;
            this.text = text;
        }

        public SignKeyword(String keyword, String text, String source) {
            this.keyword = keyword;
            this.text = text;
            this.source = source;
        }

        public String getSource() {
            return source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public String getKeyword() {
            return keyword;
        }

        public void setKeyword(String keyword) {
            this.keyword = keyword;
        }

        public String getText() {
            return text;
        }

        public void setText(String text) {
            this.text = text;
        }
    }

}
