package cn.com.duiba.tuia.youtui.center.api.dto.youtui;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * Created by xuefeng on 2018/5/21.
 */
@ApiModel("内容")
public class YoutuiContentReq implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "内容id", dataType = "Long")
    private Long contentId;

    @ApiModelProperty(value = "内容类型", dataType = "Integer")
    private Integer contentType;

    @ApiModelProperty(value = "内容类型列表", dataType = "Integer")
    private List<Integer> ctypes;

    @ApiModelProperty(value = "玩一玩内容类型（1：游戏；2：测试；3：答题；4：其他）", dataType = "Integer")
    private Integer type;

    /**
     * 上下架状态
     **/
    private Integer isPublish;

    private int pageNo = 1;

    private int pageSize = 10;

    public List<Integer> getCtypes() {
        return ctypes;
    }

    public void setCtypes(List<Integer> ctypes) {
        this.ctypes = ctypes;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public int getPageNo() {
        return pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public Long getContentId() {
        return contentId;
    }

    public void setContentId(Long contentId) {
        this.contentId = contentId;
    }

    public Integer getContentType() {
        return contentType;
    }

    public void setContentType(Integer contentType) {
        this.contentType = contentType;
    }

    public Integer getIsPublish() {
        return isPublish;
    }

    public void setIsPublish(Integer isPublish) {
        this.isPublish = isPublish;
    }
}
