package cn.com.duiba.tuia.enginex.api.filter.condition;

import java.util.List;

/**
 * @author lijicong
 * @since 2021-03-17
 */
public interface ConditionChain<Criterion extends ConditionCriterion, Compare extends ConditionCompare, Context extends ConditionContext> {

    /**
     * 获取所有的过滤条件
     * @return
     */
    List<Condition<Criterion, Compare, Context>>  getConditions();

    /**
     * 条件匹配
     * @param criterion 过滤条件规则
     * @param compares 待匹配的集合
     * @param context 过滤条件上下文
     * @return
     */
    List<Compare> match(Criterion criterion, List<Compare> compares, Context context);

}
