package cn.com.duiba.tuia.enginex.api.filter.condition.annotation;

import cn.com.duiba.tuia.enginex.api.annotation.ExecuteOrdered;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author lijicong
 * @since 2021-04-16
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE})
@Documented
public @interface ExCondition {

    /**
     * 场景ID数组，如果为空表示所有场景都适用，如果不为空表示仅在该配置场景下适用
     */
    String[] sceneIds() default {};

    /** 执行顺序 */
    int order() default ExecuteOrdered.LOWEST_PRECEDENCE;

    /** 编码，唯一*/
    String code() default "";

    /** 描述 */
    String desc() default "";
}
