package cn.com.duiba.tuia.enginex.api.model;

import cn.com.duiba.tuia.enginex.api.component.ComponentRequest;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author lijicong
 * @since 2021-03-16
 */
public class AttributeRequest implements ComponentRequest {

    protected final Map<String, Object> attributeMap = new ConcurrentHashMap<>(64);

    @Override
    public Object getAttribute(String name) {
        return attributeMap.get(name);
    }

    @Override
    public void setAttribute(String name, Object object) {
        attributeMap.put(name, object);
    }

    @Override
    public void removeAttribute(String name) {
        attributeMap.remove(name);
    }

    @Override
    public Set<String> getAttributeNames() {
        return Collections.unmodifiableSet(attributeMap.keySet());
    }
}
