/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.enginex.component.support;

import cn.com.duiba.boot.utils.AopTargetUtils;
import cn.com.duiba.tuia.enginex.api.component.Component;
import cn.com.duiba.tuia.enginex.api.component.ComponentChain;
import cn.com.duiba.tuia.enginex.api.component.ComponentRequest;
import cn.com.duiba.tuia.enginex.api.component.ComponentResponse;
import cn.com.duiba.tuia.enginex.api.component.ComponentStopException;
import cn.com.duiba.tuia.enginex.api.component.annotation.ComponentConfig;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class AbstractComponentChain
implements ComponentChain,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(AbstractComponentChain.class);
    protected ApplicationContext applicationContext;
    protected List<Component> components;

    public List<Component> getComponents() {
        return this.components;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    public void init() {
        Map componentBeansMap = this.applicationContext.getBeansOfType(Component.class);
        List components = componentBeansMap.values().stream().filter(item -> !(item instanceof ComponentChain)).collect(Collectors.toList());
        components.sort(Comparator.comparing(this::getOrder));
        this.components = components;
    }

    private int getOrder(Component component) {
        Class<?> clazz;
        ComponentConfig annotation;
        Component target = component;
        if (AopUtils.isAopProxy((Object)component)) {
            try {
                target = (Component)AopTargetUtils.getTarget((Object)component);
            }
            catch (Exception e) {
                log.error("\u4ee3\u7406\u7c7b\u83b7\u53d6\u76ee\u6807\u7c7b\u5931\u8d25");
                return Integer.MIN_VALUE;
            }
        }
        if (Objects.isNull(annotation = (clazz = target.getClass()).getAnnotation(ComponentConfig.class))) {
            return Integer.MIN_VALUE;
        }
        return annotation.order();
    }

    public void execute(ComponentRequest request, ComponentResponse response) {
        List<Component> components = this.getComponents();
        for (Component component : components) {
            try {
                component.execute(request, response);
            }
            catch (ComponentStopException e) {
                log.warn("\u7ec4\u4ef6\u6267\u884c\u7ec8\u6b62 request={}, response={}", new Object[]{request, response, e});
                break;
            }
            catch (Exception e) {
                log.warn("\u7ec4\u4ef6\u6267\u884c\u5f02\u5e38 request={}, response={}", new Object[]{request, response, e});
            }
        }
    }
}

