/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.log.sdk.aspect;

import cn.com.duiba.tuia.log.sdk.annotation.Log;
import cn.com.duiba.tuia.log.sdk.cache.ThreadLocalCache;
import cn.com.duiba.tuia.log.sdk.dto.LogDTO;
import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@Aspect
public class LogAspect {
    private final String OPTION_JOIN_STR = ":";
    private final Logger logger = LoggerFactory.getLogger(LogAspect.class);
    @Autowired(required=false)
    private HttpServletRequest request;

    @Pointcut(value="@annotation(cn.com.duiba.tuia.log.sdk.annotation.Log)")
    public void doing() {
    }

    @Before(value="doing()")
    public void doBefore(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        Log log = method.getAnnotation(Log.class);
        LogDTO logDTO = this.setLogDTO(log);
        this.setOpeartionContent(logDTO, joinPoint.getArgs());
        this.setFirstName(method);
        this.initRequest(logDTO);
    }

    @AfterReturning(returning="result", pointcut="doing()")
    public void doAfterReturning(Object result) throws Throwable {
    }

    @AfterThrowing(pointcut="doing()", throwing="throwable")
    public void doAfterThrowing(JoinPoint joinPoint, Throwable throwable) {
        this.logger.error("\u5199\u65e5\u5fd7\u5f02\u5e38", throwable);
    }

    private void setOpeartionContent(LogDTO logDTO, Object[] args) {
        if (args == null || ThreadLocalCache.isKeyExist("first.class")) {
            return;
        }
        logDTO.setOpeartionContent(JSON.toJSONString((Object)args));
    }

    private void initRequest(LogDTO logDTO) {
        if (this.request == null || ThreadLocalCache.isKeyExist("first.class")) {
            return;
        }
        logDTO.setUri(this.request.getRequestURI());
        logDTO.setIp(this.getIpAddr(this.request));
    }

    private void setFirstName(Method method) {
        String className = method.getClass().toString();
        if (!ThreadLocalCache.isKeyExist(className)) {
            ThreadLocalCache.put("first.class", className);
        }
    }

    private LogDTO setLogDTO(Log log) {
        LogDTO logDTO;
        LogDTO logDTO2 = logDTO = ThreadLocalCache.isKeyExist("log.key") ? (LogDTO)ThreadLocalCache.get("log.key") : new LogDTO();
        if (StringUtils.hasLength((String)log.moduleName()) && StringUtils.isEmpty((Object)logDTO.getModuleName())) {
            logDTO.setModuleName(log.moduleName());
        }
        if (log.platform() != null && StringUtils.isEmpty((Object)logDTO.getPlatform())) {
            logDTO.setPlatform(log.platform().toString());
        }
        if (StringUtils.hasLength((String)log.subModuleName()) && StringUtils.isEmpty((Object)logDTO.getSubModuleName())) {
            logDTO.setSubModuleName(log.subModuleName());
        }
        if (logDTO.getTimestamp() == null) {
            logDTO.setTimestamp(new Date());
        }
        if (StringUtils.hasLength((String)log.optionName())) {
            StringBuffer logOption = new StringBuffer();
            logOption.append(logDTO.getOptionName()).append(":").append(log.optionName());
            logDTO.setOptionName(logOption.toString());
        }
        ThreadLocalCache.put("log.key", logDTO);
        return logDTO;
    }

    private String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }
}

