/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.log.sdk.mybatis.plugin;

import cn.com.duiba.tuia.log.sdk.cache.ThreadLocalCache;
import cn.com.duiba.tuia.log.sdk.sql.SQLHelp;
import cn.com.duiba.tuia.log.sdk.sql.SQLUtils;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(args={MappedStatement.class, Object.class}, method="update", type=Executor.class)})
public class LogMybatisPlugin
implements Interceptor {
    private final Logger logger = LoggerFactory.getLogger(LogMybatisPlugin.class);
    private final int MAPPED_STATEMENT_INDEX = 0;
    private final int PARAMETER_INDEX = 1;

    public Object intercept(Invocation invocation) throws Throwable {
        try {
            MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
            Object parameter = null;
            if (invocation.getArgs().length > 1) {
                parameter = invocation.getArgs()[1];
            }
            String executeSql = this.getExecuteSql(mappedStatement.getConfiguration(), mappedStatement.getBoundSql(parameter));
            String selectSql = this.getSelectSql(executeSql);
            Executor executor = (Executor)invocation.getTarget();
            List<Map<String, Object>> resultList = SQLHelp.executeSQL(executor.getTransaction(), selectSql);
            this.setOrigin(resultList);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6sql\u8bed\u53e5\u9519\u8bef", (Throwable)e);
        }
        Object returnObj = invocation.proceed();
        return returnObj;
    }

    private void setOrigin(List<Map<String, Object>> resultList) {
        Object origin = ThreadLocalCache.get("origin.key");
        if (origin == null) {
            ThreadLocalCache.put("origin.key", resultList);
            return;
        }
        ((List)origin).addAll(resultList);
    }

    private String getSelectSql(String sql) {
        if (SQLUtils.isUpdateSql(sql)) {
            sql = SQLUtils.getSelectByUpdate(sql);
        }
        if (SQLUtils.isUpdateSql(sql)) {
            sql = SQLUtils.getSelectByUpdate(sql);
        }
        return sql;
    }

    public String getExecuteSql(Configuration configuration, BoundSql boundSql) {
        Object parameterObject = boundSql.getParameterObject();
        List parameterMappings = boundSql.getParameterMappings();
        String sql = boundSql.getSql().replaceAll("[\\s]+", " ");
        if (parameterObject == null || parameterMappings.size() == 0) {
            return sql;
        }
        TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
        if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
            return sql.replaceFirst("\\?", this.getParameterValue(parameterObject));
        }
        MetaObject metaObject = configuration.newMetaObject(parameterObject);
        for (ParameterMapping parameterMapping : parameterMappings) {
            Object obj;
            String propertyName = parameterMapping.getProperty();
            if (metaObject.hasGetter(propertyName)) {
                obj = metaObject.getValue(propertyName);
                sql = sql.replaceFirst("\\?", this.getParameterValue(obj));
                continue;
            }
            if (!boundSql.hasAdditionalParameter(propertyName)) continue;
            obj = boundSql.getAdditionalParameter(propertyName);
            sql = sql.replaceFirst("\\?", this.getParameterValue(obj));
        }
        return sql;
    }

    private String getParameterValue(Object obj) {
        String value = null;
        if (obj instanceof String) {
            value = "'" + obj.toString() + "'";
        } else if (obj instanceof Date) {
            DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, Locale.CHINA);
            value = "'" + formatter.format(new Date()) + "'";
        } else {
            value = obj != null ? obj.toString() : "";
        }
        return value;
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }
}

