/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.log.sdk.aspect;

import cn.com.duiba.tuia.log.sdk.SdkInfoLog;
import cn.com.duiba.tuia.log.sdk.annotation.Log;
import cn.com.duiba.tuia.log.sdk.cache.ThreadLocalCache;
import cn.com.duiba.tuia.log.sdk.dto.LogDTO;
import cn.com.duiba.tuia.log.sdk.tool.CookieUtils;
import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.web.context.request.RequestContextHolder;

@Order(value=1)
@Aspect
public class LogAspect {
    private final String OPTION_JOIN_STR = ":";
    private final Logger logger = LoggerFactory.getLogger(LogAspect.class);
    @Autowired(required=false)
    private HttpServletRequest request;

    @Around(value="@annotation(cn.com.duiba.tuia.log.sdk.annotation.Log)")
    public Object doing(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        try {
            this.doBefore(joinPoint, method);
        }
        catch (Throwable throwable) {
            this.logger.error("\u6253\u5370\u65e5\u5fd7\u5207\u9762\u4e4b\u524d\u5f02\u5e38", throwable);
        }
        Object result = joinPoint.proceed();
        try {
            this.doAfterReturning(method);
        }
        catch (Throwable throwable) {
            this.logger.error("\u6253\u5370\u65e5\u5fd7\u5207\u9762\u4e4b\u540e\u5f02\u5e38", throwable);
        }
        return result;
    }

    public void doBefore(ProceedingJoinPoint joinPoint, Method method) throws Throwable {
        Log log = method.getAnnotation(Log.class);
        LogDTO logDTO = this.setLogDTO(log);
        this.setOpeartionContent(logDTO, joinPoint.getArgs());
        this.initRequest(logDTO);
        this.setFirstName(method);
    }

    public void doAfterReturning(Method method) throws Throwable {
        String methodName = method.getClass().getName() + method.getName();
        if (methodName.equals(ThreadLocalCache.get("first.method"))) {
            LogDTO logDTO = (LogDTO)ThreadLocalCache.get("log.key");
            logDTO.setOriginContent(JSON.toJSONString((Object)ThreadLocalCache.get("origin.key")));
            SdkInfoLog.log(logDTO);
            ThreadLocalCache.clear();
        }
    }

    private void setOpeartionContent(LogDTO logDTO, Object[] args) {
        if (args == null || ThreadLocalCache.isKeyExist("first.method")) {
            return;
        }
        ArrayList<Object> operationArgs = new ArrayList<Object>(args.length);
        int len = args.length;
        for (int i = 0; i < len; ++i) {
            if (args[i] instanceof ServletResponse || args[i] instanceof Errors) continue;
            operationArgs.add(args[i]);
        }
        logDTO.setOperationContent(JSON.toJSONString((Object)JSON.toJSON(operationArgs)));
    }

    private void initRequest(LogDTO logDTO) {
        if (RequestContextHolder.getRequestAttributes() == null || ThreadLocalCache.isKeyExist("first.method")) {
            return;
        }
        logDTO.setUri(this.request.getRequestURI());
        logDTO.setIp(this.getIpAddr(this.request));
        logDTO.setAccountInfo(CookieUtils.getCookie(this.request, "dataxyz345"));
    }

    private void setFirstName(Method method) {
        String methodName = method.getClass().getName() + method.getName();
        if (!ThreadLocalCache.isKeyExist(methodName)) {
            ThreadLocalCache.put("first.method", methodName);
        }
    }

    private LogDTO setLogDTO(Log log) {
        LogDTO logDTO;
        LogDTO logDTO2 = logDTO = ThreadLocalCache.isKeyExist("log.key") ? (LogDTO)ThreadLocalCache.get("log.key") : new LogDTO();
        if (StringUtils.hasLength((String)log.moduleName()) && StringUtils.isEmpty((Object)logDTO.getModuleName())) {
            logDTO.setModuleName(log.moduleName());
        }
        if (log.platform() != null && StringUtils.isEmpty((Object)logDTO.getPlatform())) {
            logDTO.setPlatform(log.platform().toString());
        }
        if (StringUtils.hasLength((String)log.subModuleName()) && StringUtils.isEmpty((Object)logDTO.getSubModuleName())) {
            logDTO.setSubModuleName(log.subModuleName());
        }
        if (logDTO.getTimestamp() == null) {
            logDTO.setTimestamp(new Date());
        }
        if (StringUtils.hasLength((String)log.optionName())) {
            StringBuffer logOption = new StringBuffer();
            if (StringUtils.hasLength((String)logDTO.getOptionName())) {
                logOption.append(logDTO.getOptionName());
            }
            logOption.append(":").append(log.optionName());
            logDTO.setOptionName(logOption.toString());
        }
        ThreadLocalCache.put("log.key", logDTO);
        return logDTO;
    }

    private String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }
}

