/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.union.star.center.api.cache.service.impl;

import cn.com.duiba.tuia.union.star.center.api.cache.service.RemoteDeviceUaParseCache;
import cn.com.duiba.tuia.union.star.center.api.cache.service.utils.UaSplitUtils;
import cn.com.duiba.tuia.union.star.center.api.remoteservice.RemoteDeviceUaParseService;
import cn.com.duiba.tuia.union.star.center.api.remoteservice.domain.rsp.MobileUaInfoDTO;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class RemoteDeviceUaParseCacheImpl
implements RemoteDeviceUaParseCache {
    private static final Logger log = LoggerFactory.getLogger(RemoteDeviceUaParseCacheImpl.class);
    @Autowired
    private ExecutorService executorService;
    @Resource
    private RemoteDeviceUaParseService remoteDeviceUaParseService;
    private LoadingCache<String, Optional<MobileUaInfoDTO>> MOBILE_UA_CACHE;
    @Value(value="${us.expire.refresh.seconds:600}")
    public Integer US_EXPIRE_REFRESH_SECONDS;
    private CacheLoader<String, Optional<MobileUaInfoDTO>> MOBILE_UA_CACHE_LOADER = new CacheLoader<String, Optional<MobileUaInfoDTO>>(){

        public Optional<MobileUaInfoDTO> load(String phoneModel) {
            if (StringUtils.isEmpty((CharSequence)phoneModel)) {
                return Optional.empty();
            }
            MobileUaInfoDTO mobileUaInfoDTO = RemoteDeviceUaParseCacheImpl.this.remoteDeviceUaParseService.selectUaParseInfoByPhoneModel(phoneModel);
            log.info("phoneModel={}, mobileUaInfoDTO={}", (Object)phoneModel, (Object)mobileUaInfoDTO);
            return Optional.ofNullable(mobileUaInfoDTO);
        }

        public ListenableFuture<Optional<MobileUaInfoDTO>> reload(String keyStr, Optional<MobileUaInfoDTO> oldValue) {
            ListenableFutureTask task = ListenableFutureTask.create(() -> {
                Optional<MobileUaInfoDTO> result;
                try {
                    result = this.load(keyStr);
                }
                catch (Exception e) {
                    log.error("MOBILE_UA_CACHE_LOADER reload e", (Throwable)e);
                    return oldValue;
                }
                return result;
            });
            RemoteDeviceUaParseCacheImpl.this.executorService.submit((Runnable)task);
            return task;
        }
    };

    @PostConstruct
    public void init() {
        this.MOBILE_UA_CACHE = CacheBuilder.newBuilder().maximumSize(10000L).concurrencyLevel(20).refreshAfterWrite((long)this.US_EXPIRE_REFRESH_SECONDS.intValue(), TimeUnit.SECONDS).build(this.MOBILE_UA_CACHE_LOADER);
    }

    @Override
    public MobileUaInfoDTO getMobileInfoByUa(String ua) {
        if (StringUtils.isBlank((CharSequence)ua)) {
            return null;
        }
        Optional mobileUaInfoDTO = null;
        try {
            String phoneModel = UaSplitUtils.parseUaToPhoneModel(ua.toLowerCase());
            log.info("ua={}, phoneModel={}", (Object)ua, (Object)phoneModel);
            if (StringUtils.isBlank((CharSequence)phoneModel)) {
                return null;
            }
            mobileUaInfoDTO = (Optional)this.MOBILE_UA_CACHE.get((Object)phoneModel);
        }
        catch (ExecutionException e) {
            log.warn("MOBILE_UA_CACHE get error.ua={}", (Object)ua, (Object)e);
            return null;
        }
        return mobileUaInfoDTO.orElse(null);
    }
}

