/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.union.star.center.api.cache.service.impl;

import cn.com.duiba.tuia.union.star.center.api.cache.service.RemoteDomainUrlInfoCache;
import cn.com.duiba.tuia.union.star.center.api.remoteservice.RemoteDomainUrlInfoService;
import cn.com.duiba.tuia.union.star.center.api.remoteservice.domain.rsp.DomainUrlInfoDTO;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteDomainUrlInfoCacheImpl
implements RemoteDomainUrlInfoCache {
    private static final Logger log = LoggerFactory.getLogger(RemoteDomainUrlInfoCacheImpl.class);
    @Autowired
    private ExecutorService executorService;
    @Autowired
    private RemoteDomainUrlInfoService remoteDomainUrlInfoService;
    private CacheLoader<String, String> DOMAIN_BEIAN_LOADER = new CacheLoader<String, String>(){

        public String load(String keyStr) {
            if (StringUtils.isEmpty((String)keyStr)) {
                return "";
            }
            DomainUrlInfoDTO domainUrlInfoDTO = RemoteDomainUrlInfoCacheImpl.this.remoteDomainUrlInfoService.selectDomainUrlInfoByUrl(keyStr);
            return domainUrlInfoDTO == null ? "" : (StringUtils.isBlank((String)domainUrlInfoDTO.getDomainBeianInfo()) ? "" : domainUrlInfoDTO.getDomainBeianInfo());
        }

        public ListenableFuture<String> reload(String keyStr, String oldValue) {
            ListenableFutureTask task = ListenableFutureTask.create(() -> {
                String resStr;
                try {
                    resStr = this.load(keyStr);
                }
                catch (Exception e) {
                    log.error("APOLLO_STRING_LOADER reload e", (Throwable)e);
                    return oldValue;
                }
                return resStr;
            });
            RemoteDomainUrlInfoCacheImpl.this.executorService.submit((Runnable)task);
            return task;
        }
    };
    private LoadingCache<String, String> DOMAIN_BEIAN_CACHE = CacheBuilder.newBuilder().initialCapacity(500).concurrencyLevel(20).refreshAfterWrite(30L, TimeUnit.MINUTES).expireAfterWrite(8L, TimeUnit.HOURS).build(this.DOMAIN_BEIAN_LOADER);

    @Override
    public String getDomainBeian(String domainUrl) {
        if (StringUtils.isBlank((String)domainUrl)) {
            return "";
        }
        try {
            return (String)this.DOMAIN_BEIAN_CACHE.get((Object)domainUrl);
        }
        catch (ExecutionException e) {
            log.warn("DOMAIN_BEIAN_CACHE get fail.domainUrl={}", (Throwable)e);
            return "";
        }
    }
}

