/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.union.star.center.api.cache.service.utils;

import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class UaSplitUtils {
    private static final String UA = "User-Agent";
    private static final String ANDR = "android";
    private static final String IPH = "iphone";
    private static final String IPAD = "ipad";
    private static String HOS = "harmonyos;";

    public static String parseUaToPhoneModel(String ua) {
        String tempUa = UaSplitUtils.getAndroidIosFromUa(ua);
        if (StringUtils.isBlank((CharSequence)tempUa)) {
            return null;
        }
        if (tempUa.startsWith(IPH)) {
            return IPH;
        }
        if (tempUa.startsWith(IPAD)) {
            return IPAD;
        }
        if (tempUa.startsWith("linux")) {
            String phoneModel = UaSplitUtils.getDeviceInfo(ua);
            if (StringUtils.isBlank((CharSequence)phoneModel)) {
                return null;
            }
            return phoneModel;
        }
        return null;
    }

    private static String getDeviceInfo(String ua) {
        if (StringUtils.isBlank((CharSequence)ua)) {
            return null;
        }
        String uaCoreFix = null;
        try {
            uaCoreFix = UaSplitUtils.getUaCoreFix(ua);
        }
        catch (Exception e) {
            return null;
        }
        int i = uaCoreFix.trim().indexOf(" ");
        uaCoreFix = uaCoreFix.substring(i + 1).trim();
        int j = uaCoreFix.indexOf(" ");
        if (j < 0) {
            return uaCoreFix;
        }
        return uaCoreFix.substring(j + 1).trim().replaceAll(" ", "");
    }

    private static String getUaCoreFix(String ua) throws Exception {
        ua = URLDecoder.decode(ua, "utf-8");
        String tempUa = UaSplitUtils.getAndroidIosFromUa(ua = ua.toLowerCase());
        if (StringUtils.isEmpty((CharSequence)tempUa)) {
            return ua.replaceAll("[^a-z0-9]", "");
        }
        tempUa = tempUa.replaceAll(" u;", "");
        tempUa = tempUa.replaceAll("; wv", "");
        tempUa = tempUa.replaceAll("\\s\\w\\w-\\w\\w;", "");
        tempUa = tempUa.replaceAll("zh-cn;", "");
        tempUa = tempUa.replaceAll("%20", "");
        return UaSplitUtils.getAnalysisUa(tempUa);
    }

    private static String getAndroidIosFromUa(String ua) {
        if (StringUtils.isEmpty((CharSequence)ua)) {
            return "";
        }
        if (!ua.contains(ANDR) && !ua.contains(IPH)) {
            return "";
        }
        if (!ua.contains("(") || !ua.contains(")")) {
            return "";
        }
        if (ua.contains(HOS)) {
            ua = ua.replaceAll(HOS, "");
        }
        String[] split = ua.split("\\(");
        String tempUa = "";
        for (int i = 0; i < split.length && !(tempUa = split[i]).contains(ANDR) && !tempUa.contains(IPH); ++i) {
        }
        return tempUa.split("\\)")[0];
    }

    private static String getAnalysisUa(String ua) {
        String[] split;
        if (ua.length() > 200) {
            return ua.substring(0, 200);
        }
        if (ua.contains(ANDR)) {
            split = ua.split(";");
            for (int i = 0; i < split.length; ++i) {
                String tempStr = split[i];
                if (!tempStr.contains(ANDR)) continue;
                if (i >= split.length - 1) {
                    return tempStr;
                }
                String mobileStr = split[i + 1];
                return tempStr + mobileStr.split("build/")[0];
            }
        }
        if (ua.contains(IPH)) {
            String regEx = "[^0-9]";
            Pattern p = Pattern.compile(regEx);
            Matcher matcher = p.matcher(ua);
            String iosVersion = "";
            iosVersion = matcher.replaceAll("");
            return IPH + iosVersion;
        }
        split = ua.split(";");
        String abcNum = split[0];
        abcNum = abcNum.replaceAll(" ", "");
        String regEx = "[a-z].*\\d+.*";
        Pattern p = Pattern.compile(regEx);
        if (p.matcher(abcNum).matches()) {
            return abcNum;
        }
        return ua;
    }

    public static void main(String[] args) {
        String ua = "Mozilla/5.0 (Linux; U; Android 11; zh-cn; Redmi K20 Pro Build/RKQ1.200826.002) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/79.0.3945.147 Mobile Safari/537.36 XiaoMi/MiuiBrowser/15.0.0";
        String phoneModel = UaSplitUtils.parseUaToPhoneModel(ua.toLowerCase());
        System.out.println(phoneModel);
    }
}

