/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.union.star.center.api.remoteservice.domain.utils;

public class RadixUtils {
    public static int MIN_RADIX = 2;
    public static int MAX_RADIX = 62;
    private static final String num62 = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

    private RadixUtils() {
    }

    public static String baseConver(String number, int fromRadix, int toRadix) {
        long dec = RadixUtils.any2Dec(number, fromRadix);
        return RadixUtils.dec2Any(dec, toRadix);
    }

    public static String dec2Any(long dec, int toRadix) {
        boolean isNegative;
        if (toRadix < MIN_RADIX || toRadix > MAX_RADIX) {
            toRadix = 2;
        }
        if (toRadix == 10) {
            return String.valueOf(dec);
        }
        char[] buf = new char[65];
        int charPos = 64;
        boolean bl = isNegative = dec < 0L;
        if (!isNegative) {
            dec = -dec;
        }
        while (dec <= (long)(-toRadix)) {
            buf[charPos--] = num62.charAt((int)(-(dec % (long)toRadix)));
            dec /= (long)toRadix;
        }
        buf[charPos] = num62.charAt((int)(-dec));
        if (isNegative) {
            buf[--charPos] = 45;
        }
        return new String(buf, charPos, 65 - charPos);
    }

    public static long any2Dec(String number, int fromRadix) {
        long dec = 0L;
        long digitValue = 0L;
        int len = number.length() - 1;
        for (int t = 0; t <= len; ++t) {
            digitValue = num62.indexOf(number.charAt(t));
            dec = dec * (long)fromRadix + digitValue;
        }
        return dec;
    }
}

