package cn.com.duiba.tuia.union.star.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.union.star.center.api.remoteservice.domain.req.ShortLinkReq;
import cn.com.duiba.tuia.union.star.center.api.remoteservice.domain.rsp.OriginalUrlRsp;

/**
 * @ClassName RemoteShortLinkService
 * @Description 短链服务
 * @Author Zaizai
 * @Date 2020/12/16 4:43 下午
 **/
@AdvancedFeignClient
public interface RemoteShortenerService {

    /**
     * 保存短链信息
     * @param shortLinkReq
     * @return 是否保存成功
     */
    boolean saveShortLink(ShortLinkReq shortLinkReq);

    /**
     * 获取原链接信息
     * @param shortLink 短链接
     * @return
     */
    OriginalUrlRsp getOriginalUrl(String shortLink);

}
