/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.com.duiba.tuia.union.star.center.api.remoteservice.orc;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * orc 文字
 */
@Data
public class AdTextDetection implements Serializable {
    private static final long serialVersionUID = -5181006307703786522L;

    /**
     * 识别出的文本行内容
     */
    private String detectedText;

    /**
     * 置信度 0 ~100
     */
    private Long confidence;

    /**
     * 文本行坐标，以四个顶点坐标表示
     */
    private List<Coord> coordList;

    /**
     * 此字段为扩展字段
     * 存放：GeneralBasicOcr接口返回段落信息Parag，包含ParagNo。
     */
    private String advancedInfo;
}

