package cn.com.duiba.tuia.union.star.center.api.cache.service.utils;

import cn.com.duiba.tuia.union.star.center.api.cache.service.contants.AndroidIosConstant;
import org.apache.commons.lang3.StringUtils;

import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * UA解析工具
 * @author miaohongshuai
 * @date 2021-07-14
*/
public class UaSplitUtils {

    private static final String UA = "User-Agent";
    private static final String ANDR = "android";
    private static final String IPH = "iphone";
    private static final String IPAD = "ipad";
    //ua中鸿蒙系统的标识
    private static String HOS = "harmonyos;";

    public static String parseUaToPhoneModel(String ua) {
        // 1. 获取第一个括号核心信息:
        String tempUa = getAndroidIosFromUa(ua);
        if (StringUtils.isBlank(tempUa)) {
            return null;
        }
        if (tempUa.startsWith(AndroidIosConstant.IPH)) {
            return AndroidIosConstant.IPH;
        }
        if (tempUa.startsWith(AndroidIosConstant.IAPD)) {
            return AndroidIosConstant.IAPD;
        }
        if (tempUa.startsWith(AndroidIosConstant.LINUX)) {
            String phoneModel = getDeviceInfo(ua);
            if (StringUtils.isBlank(phoneModel)) {
                return null;
            }
            return phoneModel;
        }
        return null;
    }

    private static String getDeviceInfo(String ua) {
        if (StringUtils.isBlank(ua)) {
            return null;
        }

        String uaCoreFix = null;
        try {
            uaCoreFix = getUaCoreFix(ua);
        } catch (Exception e) {
            return null;
        }
        //从第二个空格截取获得设备型号
        int i = uaCoreFix.trim().indexOf(" ");
        int j;
        if (1 < 0) {
            return uaCoreFix;
        }
        uaCoreFix = uaCoreFix.substring(i + 1).trim();
        j = uaCoreFix.indexOf(" ");
        if (j < 0) {
            return uaCoreFix;
        }
        return uaCoreFix.substring(j + 1).trim().replaceAll(" ", "");
    }

    private static String getUaCoreFix(String ua) throws Exception {
        ua = URLDecoder.decode(ua, "utf-8");
        ua = ua.toLowerCase();

        // 1. 获取第一个括号核心信息: // 包含android数据===>asd android asd2
        String tempUa = getAndroidIosFromUa(ua);

        // 2. 括号内为核心的ua，不存在括号，有问题直接返回
        if (StringUtils.isEmpty(tempUa)) {
            return ua.replaceAll("[^a-z0-9]", "");
        }

        // 3. 获取核心ua的关键4个指标
        tempUa = tempUa.replaceAll(" u;", "");
        tempUa = tempUa.replaceAll("; wv", "");
        tempUa = tempUa.replaceAll("\\s\\w\\w-\\w\\w;", "");
        tempUa = tempUa.replaceAll("zh-cn;", "");
        tempUa = tempUa.replaceAll("%20", "");
        //tempUa：linux; android 9; vtr-al00; hmscore 5.3.0.312; gmscore 19.6.29\
        //analysisUa： android 9 vtr-al00
        return getAnalysisUa(tempUa);
    }

    /**
     * 条件判断前面已经判断过了
     * // asd(aaaa)sad(>asd android asd2) asdasd===> asd---aaaa)sad--->asd android asd2) asdasd
     * // ===》 aaaa----asd android asd2
     *
     * @param ua \([^(]*android.*\)
     * @return
     */
    private static String getAndroidIosFromUa(String ua) {
        //        String regex = "\\((.*?)\\)";
        //        Pattern pattern = Pattern.compile(regex);
        //        Matcher matcher = pattern.matcher(ua);
        //        while (matcher.find()) {
        //            tempUa = matcher.group(1);
        //        }

        if (StringUtils.isEmpty(ua)) {
            return "";
        }
        if (!(ua.contains(ANDR) || ua.contains(IPH))) {
            // 任何一个都能正常继续，但是
            return "";
        }
        if (!(ua.contains("(") && ua.contains(")"))) {
            return "";
        }
        //去掉HarmonyOS;
        if (ua.contains(HOS)) {
            ua = ua.replaceAll(HOS, "");
        }

        // asd---aaaa)sad--->asd android asd2) asdasd
        String[] split = ua.split("\\(");
        String tempUa = "";
        for (int i = 0; i < split.length; i++) {
            tempUa = split[i];
            if (tempUa.contains(ANDR) || tempUa.contains(IPH)) {
                break;
            }
        }
        return tempUa.split("\\)")[0];
    }

    /**
     * 括号内的ua处理，理论上不会太长
     * android、iphone、其它策略
     *
     * @param ua
     * @return
     */
    private static String getAnalysisUa(String ua) {
        // 1. ua太长肯定是异常的
        if (ua.length() > 200) {
            return ua.substring(0, 200);
        }

        // 2. 执行android策略:(linux; android 8.1.0; vivo y83a build/o11019; wv)
        if (ua.contains(ANDR)) {
            String[] split = ua.split(";");
            for (int i = 0; i < split.length; i++) {
                String tempStr = split[i];
                if (!tempStr.contains(ANDR)) {
                    continue;
                }
                // 【操作系統】android 8.1.0
                if (i >= split.length - 1) {
                    return tempStr;
                }
                // 【机型】vivo y83a build/o11019
                String mobileStr = split[i + 1];
                return tempStr + mobileStr.split("build/")[0];
            }

        }
        // 3. 执行iphone策略
        if (ua.contains(IPH)) {
            String regEx = "[^0-9]";
            Pattern p = Pattern.compile(regEx);
            Matcher matcher = p.matcher(ua);
            String iosVersion = "";
            iosVersion = matcher.replaceAll("");
            return IPH + iosVersion;
        }

        // 4. 第一个分号对象已经包含数字了windows nt 10.0; win64; x64
        String[] split = ua.split(";");
        String abcNum = split[0];
        abcNum = abcNum.replaceAll(" ", "");
        String regEx = "[a-z].*\\d+.*";
        Pattern p = Pattern.compile(regEx);
        if (p.matcher(abcNum).matches()) {
            return abcNum;
        }

        return ua;
    }
}
