package cn.com.duiba.tuia.union.star.center.api;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.tuia.union.star.center.api.remoteservice.RemoteIdCardNameService;
import cn.com.duiba.tuia.union.star.center.api.remoteservice.req.IdCardNameReq;
import cn.com.duiba.tuia.union.star.center.api.remoteservice.result.IdCardNameResult;
import com.dianping.cat.Cat;
import lombok.extern.slf4j.Slf4j;

/**
 * 描述：
 *
 * @author zhouziwu
 * @date 2022-02-10
 */
@Slf4j
public class RemoteIdCardNameServiceFallback implements RemoteIdCardNameService {
    @Override
    public boolean checkIdCardName(String idCard, String name, String bizKey) throws BizException {
        try {
            Cat.logMetricForCount("调用易源接口超时");
        } catch (Exception e) {
            log.error("Cat log error", e);
        }
        log.warn("易源身份证接口超时熔断，姓名：{}，业务key：{}", name, bizKey);
        return true;
    }

    @Override
    public IdCardNameResult checkIdCardNameWithBizKey(IdCardNameReq idCardNameReq) {
        IdCardNameResult idCardNameResult = new IdCardNameResult();
        //这里依然设置匹配结果为匹配 请求方可以根据自己的需求来处理超时情况下的兜底处理逻辑
        idCardNameResult.setMatch(true);
        idCardNameResult.setTimeOut(true);

        try {
            Cat.logMetricForCount("调用易源接口超时");
        } catch (Exception e) {
            log.error("Cat log error", e);
        }
        log.warn("易源身份证接口超时熔断，姓名：{}，业务key：{}", idCardNameReq.getName(), idCardNameReq.getBizKey());

        return idCardNameResult;
    }

    @Override
    public IdCardNameResult checkIdCardNameWithMysqlOnly(IdCardNameReq idCardNameReq) {
        return new IdCardNameResult(false);
    }

    @Override
    public String getYiYuanRequestCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addYiYuanRequestCount(Integer count) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getYiYuanRequestAmount() {
        throw new UnsupportedOperationException();
    }
}
