package cn.com.duiba.tuia.union.star.center.api.remoteservice;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.union.star.center.api.remoteservice.domain.rsp.DomainUrlInfoDTO;

import java.util.List;

/**
 * 域名备案信息Service接口
 * 
 * @author YanfeiAndAHai
 * @date 2021-03-03
 */
@AdvancedFeignClient
public interface RemoteDomainUrlInfoService {
    /**
     * 查询域名备案信息
     * 
     * @param id 域名备案信息ID
     * @return 域名备案信息
     */
    DomainUrlInfoDTO selectDomainUrlInfoById(Long id);

    /**
     * 根据域名查询域名备案信息
     *
     * @param domainUrl 一级域名
     * @return 域名备案信息
     */
    DomainUrlInfoDTO selectDomainUrlInfoByUrl(String domainUrl);

    /**
     * 查询域名备案信息列表
     * 
     * @param domainUrlInfoDTO 域名备案信息
     * @return 域名备案信息集合
     */
    List<DomainUrlInfoDTO> selectDomainUrlInfoList(DomainUrlInfoDTO domainUrlInfoDTO);

    /**
     * 清理重复的域名备案号
     * @param processKey
     * @return
     */
    boolean clearRepeatDomainUrl(String processKey);
}
