package cn.com.duiba.tuia.union.star.center.api.remoteservice.domain.enun;


import java.util.Objects;

/**
 * 手机运营商
 * @Author: xingbo
 * @Date: 2021/6/1 4:50
 */
public enum MobileIspCustomEnum {

    NON(0, "非定制"),
    MOBILE(2, "移动定版本"),
    UNICOM(3, "联通定制版"),
    TELECOM(4, "电信定制版");

    private Integer code;
    private String type;

    MobileIspCustomEnum(Integer code, String type) {
        this.code = code;
        this.type = type;
    }

    public static String getType(Integer code) {
        MobileIspCustomEnum[] mobilePriceEnums = MobileIspCustomEnum.values();
        for (MobileIspCustomEnum mobileIspCustomEnum : mobilePriceEnums) {
            if(Objects.equals(mobileIspCustomEnum.getCode(), code)){
                return mobileIspCustomEnum.getType();
            }
        }
        return NON.getType();
    }


    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
}
