package cn.com.duiba.tuia.union.star.center.api.remoteservice.domain.enun;

import java.util.Objects;

/**
 * 手机价格
 * @Author: xingbo
 * @Date: 2021/6/1 4:50
 */
public enum MobilePriceEnum {

    LEVEL_ONE(1, "0~599"),
    LEVEL_TWO(2, "600~1099"),
    LEVEL_THREE(3, "1100~1799"),
    LEVEL_FOUR(4, "1700~2699"),
    LEVEL_FIVE(5, "2700~4499"),
    LEVEL_SIX(6, "4500+");

    private Integer level;
    private String price;

    MobilePriceEnum(Integer level, String price) {
        this.level = level;
        this.price = price;
    }

    public static String getPriceBylevel(Integer level) {
        MobilePriceEnum[] mobilePriceEnums = MobilePriceEnum.values();
        for (MobilePriceEnum mobilePriceEnum : mobilePriceEnums) {
            if(Objects.equals(mobilePriceEnum.getLevel(), level)){
                return mobilePriceEnum.getPrice();
            }
        }
        return LEVEL_ONE.getPrice();
    }

    public String getPrice() {
        return price;
    }

    public Integer getLevel() {
        return level;
    }
}
