package cn.com.duiba.tuia.ipua.api.dto;

import lombok.Data;

import java.io.Serializable;

@Data
public class IpuaPoolDTO implements Serializable {

    private static final long serialVersionUID = 8095411543177707183L;

    /**
     * 传参为空从HttpRequest取
     */
    private String ip;

    /**
     * 传参为空从HttpRequest取
     * ua不会太长，不超过200字符
     */
    private String ua;

    /**
     * imei1,类型1,来源slot1,ttl将来1h的时间戳；imei2,类型1,来源slot2,ttl将来1h的时间戳
     * deviceType: 不清楚来源就选择默认0，设备类型：1imei、2idfa、3oaid
     * todo
     * 前期严格，实际意义上讲，一个大体量的APP，如字节，他们的用户唯一标志我们也是可以用的
     */
    private String deviceIdMd5;
    private String deviceType = "0";
    private String slotId;

    /**
     * 标记使用，一般带有明确的设备号，用来校验准确率，一般为sdk流量
     * 默认“0”不是SDK流量，"1"是SDK用于测试流量
     */
    private String sdkFlag = "0";

    /**
     * 鉴权使用的参数
     */
    private String deptAndKey;

    /**
     * 额外信息存储到redis中，打印到日志中
     */
    private String extInfo;
}
