package cn.com.duiba.tuia.ipua.api.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * @Author: xingbo
 * @Date: 2021/6/1 2:00
 */
@Data
public class UaParseDTO implements Serializable {
    /**
     * 手机型号
     */
    private String phoneModel = "unknown";

    /**
     * 品牌名称英文
     */
    private String brandNameEn = "unknown";
    /**
     * 品牌名称中文
     */
    private String brandNameCn = "unknown";

    /**
     * 操作系统
     */
    private String deviceOs = "unknown";

    /**
     * 手机价格
     */
    private String price = "unknown";

    /**
     * 运营商标签:默认0不定制，1移动、2联通、3电信
     */
    private Integer dmpIspCustom;

    /**
     * 人群标签
     */
    private String consumerTag;

    /**
     * 应用市场唤起字段
     */
    private String brandMarket;

    /**
     * 操作系统：android、ios
     */
    private String phoneOs;

    /**
     * 操作系统最新版本号
     */
    private String phoneOsVersion;

    /**
     * 首发时间如2015
     */
    private Long firstShowTime;

    /**
     * 卡槽数量
     */
    private Integer cardSlotCount;

    /**
     * 采样ua
     */
    private String sampleUa;

    /**
     * 备注
     */
    private String jsonExt;

    /**
     * 最高历史pv
     */
    private String historyPv;
}
