package cn.com.duiba.tuia.ipua.api.localservice.ua;

import cn.com.duiba.tuia.ipua.api.dto.UaParseDTO;
import cn.com.duiba.tuia.ipua.api.remoteservice.RemoteUaParseService;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;


import java.util.concurrent.TimeUnit;


/**
 * @Description: 当前代码是提供给客户端==>调用本服务端的
 * 可以Copy到本地使用
 * @Author: xingbo
 * @Date: 2021/7/2
 */
@Slf4j
@Service
public class UaServiceImpl implements LocalUaService {

    private LoadingCache<String, UaParseDTO> deviceInfoCache;

    @Resource
    private RemoteUaParseService remoteUaParseService;

    /**
     * 初始化缓存
     */
    @PostConstruct
    public void initCache() {
        deviceInfoCache = Caffeine
                .newBuilder()
                .maximumSize(1024)
                .refreshAfterWrite(1, TimeUnit.HOURS)
                .expireAfterWrite(6, TimeUnit.HOURS)
                .build(new CacheLoader<String, UaParseDTO>() {
                    @CheckForNull
                    @Override
                    public UaParseDTO load(@Nonnull String phoneModel) {
                        //通过设备型号查询对应信息
                        UaParseDTO mobileUaInfoDTO = remoteUaParseService.parseDeviceUa(phoneModel, false);
                        return mobileUaInfoDTO;
                    }
                });
    }


    @Override
    public UaParseDTO parseDeviceUa(String ua) {
        return deviceInfoCache.get(ua);
    }
}
