/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.ipua.api.localservice.ua;

import cn.com.duiba.tuia.ipua.api.dto.UaParseDTO;
import cn.com.duiba.tuia.ipua.api.localservice.ua.LocalUaService;
import cn.com.duiba.tuia.ipua.api.remoteservice.RemoteUaParseService;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UaServiceImpl
implements LocalUaService {
    private static final Logger log = LoggerFactory.getLogger(UaServiceImpl.class);
    private LoadingCache<String, UaParseDTO> deviceInfoCache;
    @Resource
    private RemoteUaParseService remoteUaParseService;

    @PostConstruct
    public void initCache() {
        this.deviceInfoCache = Caffeine.newBuilder().maximumSize(1024L).refreshAfterWrite(1L, TimeUnit.HOURS).expireAfterWrite(6L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, UaParseDTO>(){

            @CheckForNull
            public UaParseDTO load(@Nonnull String phoneModel) {
                UaParseDTO mobileUaInfoDTO = UaServiceImpl.this.remoteUaParseService.parseDeviceUa(phoneModel, false);
                return mobileUaInfoDTO;
            }
        });
    }

    @Override
    public UaParseDTO parseDeviceUa(String ua) {
        return (UaParseDTO)this.deviceInfoCache.get((Object)ua);
    }
}

