package cn.com.tuia.advert.model;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author fanjia
 * @date 2021年11月25日 下午2:26
 */

public class AdxDirectAdvertDto implements Serializable {
    private static final long serialVersionUID = -6827246815657910300L;

    /**
     * 广告计划id
     */
    private Long advertId;

    /**
     * 配置包id
     */
    private Long orientationId;


    /**
     * 预估ctr
     */
    private Double preCtr;

    /**
     * 预估出价
     */
    private Long fee;

    /**
     * 排序
     */
    private Integer rank;


    /**
     * 订单ID
     */
    private String orderId;



    /**
     * 素材id-（流量线传递的创意素材id	）
     */
    private Long adxMaterialId;

    /**
     *创意计划id	-（流量线那边传递的。反查回来的）
     */
    private Long ideaId;


    /** 深度链接 dp链接 */
    private String promoteDeepLink;

    /** app下载链接（apk链接）*/
    private String appDownloadUrl;


    /** 落地页-推广网址. */
    private String promoteUrl;

    // 广告的sdk信息
    private AdvertSdkDto advertSdkDto;

    /** 广告推广计划-应用下载类型的相关字段*/
    private AdvertAppInfoDto advertAppInfoDto;


    public AdvertSdkDto getAdvertSdkDto() {
        return advertSdkDto;
    }

    public void setAdvertSdkDto(AdvertSdkDto advertSdkDto) {
        this.advertSdkDto = advertSdkDto;
    }

    public Long getOrientationId() {
        return orientationId;
    }

    public void setOrientationId(Long orientationId) {
        this.orientationId = orientationId;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Double getPreCtr() {
        return preCtr;
    }

    public void setPreCtr(Double preCtr) {
        this.preCtr = preCtr;
    }

    public Long getFee() {
        return fee;
    }

    public void setFee(Long fee) {
        this.fee = fee;
    }

    public Integer getRank() {
        return rank;
    }

    public void setRank(Integer rank) {
        this.rank = rank;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public Long getAdxMaterialId() {
        return adxMaterialId;
    }

    public void setAdxMaterialId(Long adxMaterialId) {
        this.adxMaterialId = adxMaterialId;
    }

    public Long getIdeaId() {
        return ideaId;
    }

    public void setIdeaId(Long ideaId) {
        this.ideaId = ideaId;
    }

    public String getPromoteDeepLink() {
        return promoteDeepLink;
    }

    public void setPromoteDeepLink(String promoteDeepLink) {
        this.promoteDeepLink = promoteDeepLink;
    }

    public String getAppDownloadUrl() {
        return appDownloadUrl;
    }

    public void setAppDownloadUrl(String appDownloadUrl) {
        this.appDownloadUrl = appDownloadUrl;
    }

    public String getPromoteUrl() {
        return promoteUrl;
    }

    public void setPromoteUrl(String promoteUrl) {
        this.promoteUrl = promoteUrl;
    }

    public AdvertAppInfoDto getAdvertAppInfoDto() {
        return advertAppInfoDto;
    }

    public void setAdvertAppInfoDto(AdvertAppInfoDto advertAppInfoDto) {
        this.advertAppInfoDto = advertAppInfoDto;
    }
}
