package cn.com.tuia.advert.adxService;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixCommand;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.tuia.advert.fallback.AdxEngineServiceFallbackImpl;
import cn.com.tuia.advert.model.*;
import lombok.Data;

/**
 * adx出券请求接口
 *
 * @author peanut.huang
 * @date 2019/7/4
 * @since JDK 1.8
 */
@AdvancedFeignClient(fallback = AdxEngineServiceFallbackImpl.class)
public interface AdxEngineService {

//    /**
//     * adx预发券请求
//     *
//     * @param req  req#adxLoadType，1：预发券，adx-web调用60ms熔断
//     * @fallback 降级处理，请做好兼容 {@link AdxEngineServiceFallbackImpl#preLoadAdvert}
//     * @return
//     */
//    @FeignHystrixCommand(threadPoolKey = "adx-load-advert")
//    @FeignHystrixProperty.FeignHystrixPropertys({
//        @FeignHystrixProperty(name= HystrixPropertiesManager.CORE_SIZE, value = "50"),
//        @FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "60")
//    })
//    ObtainAdvertRsp preLoadAdvert(ObtainAdvertReq req);

//    /**
//     * adx真实发券请求
//     *
//     * @param req  req#adxLoadType 2：真实发券
//     * @fallback 降级处理，请做好兼容 {@link AdxEngineServiceFallbackImpl#actLoadAdvert}
//     * @return
//     */
//    ObtainAdvertRsp actLoadAdvert(ObtainAdvertReq req);

    /**
     * adx直投发券请求
     *
     * @param req  req#adxMediaType 2：ADX直投发券
     * @return
     */
    @FeignHystrixCommand(threadPoolKey = "adx-direct-load-advert")
    @FeignHystrixProperty.FeignHystrixPropertys({
            @FeignHystrixProperty(name= HystrixPropertiesManager.CORE_SIZE, value = "50"),
            @FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "60")
    })
    ObtainAdvertRsp adxDirectLoadAdvert(ObtainAdvertReq req);

    /**
     * adx直投发券请求-新接口.上线兼容为了区分新老逻辑开的新接口-全量上线后 老接口adxDirectLoadAdvert可以下掉
     *
     * @param req  req#adxMediaType 2：ADX直投发券
     * @return
     */
    @FeignHystrixCommand(threadPoolKey = "adx-direct-load-advert")
    @FeignHystrixProperty.FeignHystrixPropertys({
            @FeignHystrixProperty(name= HystrixPropertiesManager.CORE_SIZE, value = "50"),
            @FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "60")
    })
    ObtainAdvertRsp adxDirectLoadAdvertNew(ObtainAdvertReq req);

//    /**
//     * sdk直投发券请求
//     *
//     * @param req  req#adxMediaType 4：ADX直投发券
//     * @return
//     */
//    @FeignHystrixCommand(threadPoolKey = "sdk-direct-load-advert")
//    @FeignHystrixProperty.FeignHystrixPropertys({
//            @FeignHystrixProperty(name= HystrixPropertiesManager.CORE_SIZE, value = "50"),
//            @FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "200")
//    })
//    ObtainAdvertRsp sdkDirectLoadAdvert(ObtainAdvertReq req);

    /**
     * 查询广告详情接口.
     *
     * @param req the req
     * @return the query advert rsp
     */
    QueryAdvertRsp queryAdvert(QueryAdvertReq req);

    /**
     * @param logReq    请求参数
     * @return          日志补偿是否成功
     */
    @Deprecated
    boolean reLog(AdxLogReq logReq);

    /**
     * 补打发券日志
     *
     * @param req
     * @return
     * @see #reLog(AdxLogReq)
     */
    boolean reLaunchLog(AdxLogReq req);

    /**
     * 补打曝光日志
     *
     * @param req
     * @return
     * @see #reLog(AdxLogReq)
     */
    boolean reShowLog(AdxLogReq req);
}
