package cn.com.tuia.advert.enums;

/**
 * @author Wangpf
 * @description 细化的广告类型
 * @date 2021/12/6 2:11 下午
 */
public enum RefinedAdvertTypeEnum {

    HD_DIRECT(1, "互动广告"),

    ADVERTISING_POSITION_DIRECT(2, "广告位直投落地页"),

    DP_ADVERT(3, "DP广告"),

    INCENTIVE_VIDEO(4, "激励视频"),

    ADX_DIRECT(5, "ADX直投");

    private final int refinedAdvertType;

    private final String desc;

    RefinedAdvertTypeEnum(int refinedAdvertType, String desc) {
        this.refinedAdvertType = refinedAdvertType;
        this.desc = desc;
    }

    public int getRefinedAdvertType() {
        return refinedAdvertType;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 互动场景下根据活动类型获取细化的广告类型
     *
     * @param activityType
     * @return
     */
    public static int getRefinedAdvertType(int activityType) {

        //激励视频
        if (activityType == ActivityTypeEnum.NEW_VEDIO_ADVERT_ACTIVITY_TYPE.getCode()) {
            return INCENTIVE_VIDEO.getRefinedAdvertType();
        }

        Integer code = ActivityTypeEnum.PLUGIN_ACTIVITY_TYPE.getCode();
        Integer code1 = ActivityTypeEnum.ACT_ACTIVITY_TYPE.getCode();
        Integer code2 = ActivityTypeEnum.DIRECT_PAGE_ACTIVITY_TYPE.getCode();
        Integer code3 = ActivityTypeEnum.FLOAT_ACTIVITY_TYPE.getCode();
        Integer code4 = ActivityTypeEnum.ENC_ACTIVITY_TYPE.getCode();
        Integer code5 = ActivityTypeEnum.MEITUAN_ADX.getCode();
        Integer code6 = ActivityTypeEnum.HD_DIRECT.getCode();

        //活动广告
        if (activityType == code || activityType == code1 || activityType == code2 || activityType == code3 || activityType == code4 || activityType == code5 || activityType == code6) {
            return HD_DIRECT.getRefinedAdvertType();
        }

        //广告位直投落地页
        Integer code7 = ActivityTypeEnum.DIRECT_ADVERT_ACTIVITY_TYPE_FILTER.getCode();
        if (activityType == code5) {
            return ADVERTISING_POSITION_DIRECT.getRefinedAdvertType();
        }

        Integer code8 = ActivityTypeEnum.DP_ADVERT_ACTIVITY_TYPE.getCode();
        Integer code9 = ActivityTypeEnum.DP_ADVERT_ACTIVITY_TYPE_FILTER.getCode();
        if (activityType == code6 || activityType == code7) {
            return DP_ADVERT.getRefinedAdvertType();
        }

        //todo 找不到类型的情况下，使用互动兜底是否可以
        return HD_DIRECT.getRefinedAdvertType();
    }
}
