package cn.com.tuia.advert.model;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class AdvOrientationItemDto implements Serializable {

    private static final long serialVersionUID = -3102277538569878597L;

    private String       id;
    private Long         orientationId;     // 定向id
    private Long         advertId;          // 广告id
    private Long         accountId;
    private Long         orderLevel;        // 广告排序
    private Date levelUpdateTime;   // 广告排序更新时间
    private Date         startDate;         // 开始投放时间:排期问题
    private Date         endDate;           // 结束投放时间
    private Long         cpcPrice;          // cpc报价
    private Long         cpaPrice;          // cpa报价
    private Integer      chargeType;        // 报价类型
    private Set<String> regionIds;         // 投放区域
    private Set<String>  platform;          // 投放平台
    private Set<String>  phoneLevels;       // 手机价格区间
    private Set<Integer> networkTypes;      // 网络类型
    private Set<Integer> operators;         // 网络运营商
    private Integer      ageStart;          // 年龄区间
    private Integer      ageEnd;            // 年龄区间
    private Set<String>  bannedTags;        // 定向标签
    private Set<String>  advertTags;        // 广告标签
    private Set<String>  promoteUrlTags;    // 落地页标签
    private String       resourceTag;       // 广告资源标签
    private String       newTradeTagNum;    // 广告对应新行业的tag_num，通过这个tag_num可以直接取到新行业名称
    private Set<Long>    targetApps;        // 定向媒体
    private Set<String>  targetAppSlots;    // 定向广告位
    private Set<String>  allShieldTags;     // 所有的屏蔽标签，包括定向标签、广告标签、落地页标签
    private Set<String>  globalShieldTags;  // 包括广告标签、落地页标签,给全局流量调控用
    private Set<Integer> joinNums;          // 发券顺序
    private Set<Long>    oldAdvertIds;      // 老广告id，用于排除已领的
    private String       sex;               // 性别
    private Set<String>  workState;         // 工作状态

    private String       periodListBytes;   // 压缩时段信息
    private Long         budgetPerDay;      // 每日预算
    private String       promoteUrl;        // 落地页url,用于和广告位应用的屏蔽策略匹配
    private Integer      packageType;       // 包的类型 1-人工生成的包 2-智能生成的策略包
    private Set<String>  bannedAppFlowType; // 屏蔽流量类型：1.1:微信-android,1.2:微信-ios;2.1:QQ-android,2.2:QQ-ios;3.1:支付宝-android,3.2:支付宝-ios
    private Set<String>  appFlowType;       // 定向流量类型：1:微信;2:QQ;3:支付宝;4:其他
    private Set<String>  brandName;         // 手机品牌
    private Set<String>  userInterest;      // 广告行业接受度(行业标签-接受度)：空-不限，0-其他，2-喜欢，1-接受，3-无感，4-排斥,shopping-网购，finance-金融理财，
    // health-健康养生，poker-棋牌游戏，biggame-大型游戏
    private Set<String>  activityType;      // 活动类型：1-插件工具、2-活动工具、3-直投页、-1-不限
    private BigDecimal advertWeight;      // 权重

    private Integer      supportStatus;     // 是否开启KA广告扶持，0-否、1-是

    private Integer      targetAppLimit;    // 1-无限制 2-无定向媒体 3-存在个数上限

    private Integer      autoMatch;         // 是否开启智能采买 0-否 1-是

    private Set<Long>    materialIds;       // 配置包绑定的素材
    private Integer      subtype;           // 调整因子
    private Integer      source;            // 广告来源
    private Integer      isChangePeriodList; // 是否替换为全局流量配置中的投放时段 0：不替换，1：替换

    private Set<Long>    leftMaterial;      // 过滤已投素材后的有效素材

    private Boolean      strongTarget;      // 是否是强定向

    private Integer putTargetType;//投放目标类型，11-稳定投放，2-抢量优先(中)， 3-抢量优先(高)， 4-人工定向， 5-成本优先

    private Integer order;//排序
    private Integer                  budgetSmooth;        // 消耗速度，0：加速投放，1：匀速投放

    private List<Long> limitAppList; // 限流媒体

    /**
     * limitAppList.
     *
     * @return the limitAppList
     * @since JDK 1.8
     */
    public List<Long> getLimitAppList() {
        return limitAppList;
    }

    /**
     * limitAppList.
     *
     * @param limitAppList the limitAppList to set
     * @since JDK 1.8
     */
    public void setLimitAppList(List<Long> limitAppList) {
        this.limitAppList = limitAppList;
    }

    /**
     * budgetSmooth.
     *
     * @return the budgetSmooth
     * @since JDK 1.8
     */
    public Integer getBudgetSmooth() {
        return budgetSmooth;
    }

    /**
     * budgetSmooth.
     *
     * @param budgetSmooth the budgetSmooth to set
     * @since JDK 1.8
     */
    public void setBudgetSmooth(Integer budgetSmooth) {
        this.budgetSmooth = budgetSmooth;
    }

    /**
     * order.
     *
     * @return  the order
     * @since   JDK 1.8
     */
    public Integer getOrder() {
        return order;
    }


    /**
     * order.
     *
     * @param   order    the order to set
     * @since   JDK 1.8
     */
    public void setOrder(Integer order) {
        this.order = order;
    }

    public Integer getPutTargetType() {
        return putTargetType;
    }

    public void setPutTargetType(Integer putTargetType) {
        this.putTargetType = putTargetType;
    }

    /**
     * newTradeTagNum.
     *
     * @return the newTradeTagNum
     * @since JDK 1.8
     */
    public String getNewTradeTagNum() {
        return newTradeTagNum;
    }

    /**
     * newTradeTagNum.
     *
     * @param newTradeTagNum the newTradeTagNum to set
     * @since JDK 1.8
     */
    public void setNewTradeTagNum(String newTradeTagNum) {
        this.newTradeTagNum = newTradeTagNum;
    }

    /**
     * resourceTag.
     *
     * @return the resourceTag
     * @since JDK 1.8
     */
    public String getResourceTag() {
        return resourceTag;
    }

    /**
     * resourceTag.
     *
     * @param resourceTag the resourceTag to set
     * @since JDK 1.8
     */
    public void setResourceTag(String resourceTag) {
        this.resourceTag = resourceTag;
    }

    /**
     * strongTarget.
     *
     * @return the strongTarget
     * @since JDK 1.8
     */
    public Boolean getStrongTarget() {
        return strongTarget;
    }

    /**
     * strongTarget.
     *
     * @param strongTarget the strongTarget to set
     * @since JDK 1.8
     */
    public void setStrongTarget(Boolean strongTarget) {
        this.strongTarget = strongTarget;
    }

    /**
     * targetAppSlots.
     *
     * @return the targetAppSlots
     * @since JDK 1.8
     */
    public Set<String> getTargetAppSlots() {
        return targetAppSlots;
    }

    /**
     * targetAppSlots.
     *
     * @param targetAppSlots the targetAppSlots to set
     * @since JDK 1.8
     */
    public void setTargetAppSlots(Set<String> targetAppSlots) {
        this.targetAppSlots = targetAppSlots;
    }

    /**
     * leftMaterial.
     *
     * @return the leftMaterial
     * @since JDK 1.8
     */
    public Set<Long> getLeftMaterial() {
        return leftMaterial;
    }

    /**
     * leftMaterial.
     *
     * @param leftMaterial the leftMaterial to set
     * @since JDK 1.8
     */
    public void setLeftMaterial(Set<Long> leftMaterial) {
        this.leftMaterial = leftMaterial;
    }

    /**
     * subtype.
     *
     * @return the subtype
     * @since JDK 1.8
     */
    public Integer getSubtype() {
        return subtype;
    }

    /**
     * subtype.
     *
     * @param subtype the subtype to set
     * @since JDK 1.8
     */
    public void setSubtype(Integer subtype) {
        this.subtype = subtype;
    }

    /**
     * materialIds.
     *
     * @return the materialIds
     * @since JDK 1.8
     */
    public Set<Long> getMaterialIds() {
        return materialIds;
    }

    /**
     * materialIds.
     *
     * @param materialIds the materialIds to set
     * @since JDK 1.8
     */
    public void setMaterialIds(Set<Long> materialIds) {
        this.materialIds = materialIds;
    }

    /**
     * targetAppLimit.
     *
     * @return the targetAppLimit
     * @since JDK 1.8
     */
    public Integer getTargetAppLimit() {
        return targetAppLimit;
    }

    /**
     * targetAppLimit.
     *
     * @param targetAppLimit the targetAppLimit to set
     * @since JDK 1.8
     */
    public void setTargetAppLimit(Integer targetAppLimit) {
        this.targetAppLimit = targetAppLimit;
    }

    /**
     * autoMatch.
     *
     * @return the autoMatch
     * @since JDK 1.8
     */
    public Integer getAutoMatch() {
        return autoMatch;
    }

    /**
     * autoMatch.
     *
     * @param autoMatch the autoMatch to set
     * @since JDK 1.8
     */
    public void setAutoMatch(Integer autoMatch) {
        this.autoMatch = autoMatch;
    }

    /**
     * supportStatus.
     *
     * @return the supportStatus
     * @since JDK 1.8
     */
    public Integer getSupportStatus() {
        return supportStatus;
    }

    /**
     * supportStatus.
     *
     * @param supportStatus the supportStatus to set
     * @since JDK 1.8
     */
    public void setSupportStatus(Integer supportStatus) {
        this.supportStatus = supportStatus;
    }

    /**
     * advertWeight.
     *
     * @return the advertWeight
     * @since JDK 1.8
     */
    public BigDecimal getAdvertWeight() {
        return advertWeight;
    }

    /**
     * advertWeight.
     *
     * @param advertWeight the advertWeight to set
     * @since JDK 1.8
     */
    public void setAdvertWeight(BigDecimal advertWeight) {
        this.advertWeight = advertWeight;
    }

    public Integer getIsChangePeriodList() {
        return isChangePeriodList;
    }

    public void setIsChangePeriodList(Integer isChangePeriodList) {
        this.isChangePeriodList = isChangePeriodList;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getPackageType() {
        return packageType;
    }

    public void setPackageType(Integer packageType) {
        this.packageType = packageType;
    }

    public Long getOrientationId() {
        return orientationId;
    }

    public void setOrientationId(Long orientationId) {
        this.orientationId = orientationId;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Long getOrderLevel() {
        return orderLevel;
    }

    public void setOrderLevel(Long orderLevel) {
        this.orderLevel = orderLevel;
    }

    public Date getLevelUpdateTime() {
        return levelUpdateTime;
    }

    public void setLevelUpdateTime(Date levelUpdateTime) {
        this.levelUpdateTime = levelUpdateTime;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Long getCpcPrice() {
        return cpcPrice;
    }

    public void setCpcPrice(Long cpcPrice) {
        this.cpcPrice = cpcPrice;
    }

    public Long getCpaPrice() {
        return cpaPrice;
    }

    public void setCpaPrice(Long cpaPrice) {
        this.cpaPrice = cpaPrice;
    }

    public Integer getChargeType() {
        return chargeType;
    }

    public void setChargeType(Integer chargeType) {
        this.chargeType = chargeType;
    }

    public Integer getAgeStart() {
        return ageStart;
    }

    public void setAgeStart(Integer ageStart) {
        this.ageStart = ageStart;
    }

    public Integer getAgeEnd() {
        return ageEnd;
    }

    public void setAgeEnd(Integer ageEnd) {
        this.ageEnd = ageEnd;
    }

    public String getSex() {
        return sex;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public String getPromoteUrl() {
        return promoteUrl;
    }

    public void setPromoteUrl(String promoteUrl) {
        this.promoteUrl = promoteUrl;
    }

    public Long getBudgetPerDay() {
        return budgetPerDay;
    }

    public void setBudgetPerDay(Long budgetPerDay) {
        this.budgetPerDay = budgetPerDay;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getPeriodListBytes() {
        return periodListBytes;
    }

    public void setPeriodListBytes(String periodListBytes) {
        this.periodListBytes = periodListBytes;
    }

    public Integer getSource() {
        return source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }

    /**
     * regionIds.
     *
     * @return the regionIds
     * @since JDK 1.8
     */
    public Set<String> getRegionIds() {
        return regionIds;
    }

    /**
     * regionIds.
     *
     * @param regionIds the regionIds to set
     * @since JDK 1.8
     */
    public void setRegionIds(Set<String> regionIds) {
        this.regionIds = regionIds;
    }

    /**
     * platform.
     *
     * @return the platform
     * @since JDK 1.8
     */
    public Set<String> getPlatform() {
        return platform;
    }

    /**
     * platform.
     *
     * @param platform the platform to set
     * @since JDK 1.8
     */
    public void setPlatform(Set<String> platform) {
        this.platform = platform;
    }

    /**
     * phoneLevels.
     *
     * @return the phoneLevels
     * @since JDK 1.8
     */
    public Set<String> getPhoneLevels() {
        return phoneLevels;
    }

    /**
     * phoneLevels.
     *
     * @param phoneLevels the phoneLevels to set
     * @since JDK 1.8
     */
    public void setPhoneLevels(Set<String> phoneLevels) {
        this.phoneLevels = phoneLevels;
    }

    /**
     * networkTypes.
     *
     * @return the networkTypes
     * @since JDK 1.8
     */
    public Set<Integer> getNetworkTypes() {
        return networkTypes;
    }

    /**
     * networkTypes.
     *
     * @param networkTypes the networkTypes to set
     * @since JDK 1.8
     */
    public void setNetworkTypes(Set<Integer> networkTypes) {
        this.networkTypes = networkTypes;
    }

    /**
     * operators.
     *
     * @return the operators
     * @since JDK 1.8
     */
    public Set<Integer> getOperators() {
        return operators;
    }

    /**
     * operators.
     *
     * @param operators the operators to set
     * @since JDK 1.8
     */
    public void setOperators(Set<Integer> operators) {
        this.operators = operators;
    }

    /**
     * bannedTags.
     *
     * @return the bannedTags
     * @since JDK 1.8
     */
    public Set<String> getBannedTags() {
        return bannedTags;
    }

    /**
     * bannedTags.
     *
     * @param bannedTags the bannedTags to set
     * @since JDK 1.8
     */
    public void setBannedTags(Set<String> bannedTags) {
        this.bannedTags = bannedTags;
    }

    /**
     * advertTags.
     *
     * @return the advertTags
     * @since JDK 1.8
     */
    public Set<String> getAdvertTags() {
        return advertTags;
    }

    /**
     * advertTags.
     *
     * @param advertTags the advertTags to set
     * @since JDK 1.8
     */
    public void setAdvertTags(Set<String> advertTags) {
        this.advertTags = advertTags;
    }

    /**
     * promoteUrlTags.
     *
     * @return the promoteUrlTags
     * @since JDK 1.8
     */
    public Set<String> getPromoteUrlTags() {
        return promoteUrlTags;
    }

    /**
     * promoteUrlTags.
     *
     * @param promoteUrlTags the promoteUrlTags to set
     * @since JDK 1.8
     */
    public void setPromoteUrlTags(Set<String> promoteUrlTags) {
        this.promoteUrlTags = promoteUrlTags;
    }

    /**
     * targetApps.
     *
     * @return the targetApps
     * @since JDK 1.8
     */
    public Set<Long> getTargetApps() {
        return targetApps;
    }

    /**
     * targetApps.
     *
     * @param targetApps the targetApps to set
     * @since JDK 1.8
     */
    public void setTargetApps(Set<Long> targetApps) {
        this.targetApps = targetApps;
    }

    /**
     * allShieldTags.
     *
     * @return the allShieldTags
     * @since JDK 1.8
     */
    public Set<String> getAllShieldTags() {
        return allShieldTags;
    }

    /**
     * allShieldTags.
     *
     * @param allShieldTags the allShieldTags to set
     * @since JDK 1.8
     */
    public void setAllShieldTags(Set<String> allShieldTags) {
        this.allShieldTags = allShieldTags;
    }

    /**
     * globalShieldTags.
     *
     * @return the globalShieldTags
     * @since JDK 1.8
     */
    public Set<String> getGlobalShieldTags() {
        return globalShieldTags;
    }

    /**
     * globalShieldTags.
     *
     * @param globalShieldTags the globalShieldTags to set
     * @since JDK 1.8
     */
    public void setGlobalShieldTags(Set<String> globalShieldTags) {
        this.globalShieldTags = globalShieldTags;
    }

    /**
     * joinNums.
     *
     * @return the joinNums
     * @since JDK 1.8
     */
    public Set<Integer> getJoinNums() {
        return joinNums;
    }

    /**
     * joinNums.
     *
     * @param joinNums the joinNums to set
     * @since JDK 1.8
     */
    public void setJoinNums(Set<Integer> joinNums) {
        this.joinNums = joinNums;
    }

    /**
     * oldAdvertIds.
     *
     * @return the oldAdvertIds
     * @since JDK 1.8
     */
    public Set<Long> getOldAdvertIds() {
        return oldAdvertIds;
    }

    /**
     * oldAdvertIds.
     *
     * @param oldAdvertIds the oldAdvertIds to set
     * @since JDK 1.8
     */
    public void setOldAdvertIds(Set<Long> oldAdvertIds) {
        this.oldAdvertIds = oldAdvertIds;
    }

    /**
     * workState.
     *
     * @return the workState
     * @since JDK 1.8
     */
    public Set<String> getWorkState() {
        return workState;
    }

    /**
     * workState.
     *
     * @param workState the workState to set
     * @since JDK 1.8
     */
    public void setWorkState(Set<String> workState) {
        this.workState = workState;
    }

    /**
     * bannedAppFlowType.
     *
     * @return the bannedAppFlowType
     * @since JDK 1.8
     */
    public Set<String> getBannedAppFlowType() {
        return bannedAppFlowType;
    }

    /**
     * bannedAppFlowType.
     *
     * @param bannedAppFlowType the bannedAppFlowType to set
     * @since JDK 1.8
     */
    public void setBannedAppFlowType(Set<String> bannedAppFlowType) {
        this.bannedAppFlowType = bannedAppFlowType;
    }

    /**
     * appFlowType.
     *
     * @return the appFlowType
     * @since JDK 1.8
     */
    public Set<String> getAppFlowType() {
        return appFlowType;
    }

    /**
     * appFlowType.
     *
     * @param appFlowType the appFlowType to set
     * @since JDK 1.8
     */
    public void setAppFlowType(Set<String> appFlowType) {
        this.appFlowType = appFlowType;
    }

    /**
     * brandName.
     *
     * @return the brandName
     * @since JDK 1.8
     */
    public Set<String> getBrandName() {
        return brandName;
    }

    /**
     * brandName.
     *
     * @param brandName the brandName to set
     * @since JDK 1.8
     */
    public void setBrandName(Set<String> brandName) {
        this.brandName = brandName;
    }

    /**
     * userInterest.
     *
     * @return the userInterest
     * @since JDK 1.8
     */
    public Set<String> getUserInterest() {
        return userInterest;
    }

    /**
     * userInterest.
     *
     * @param userInterest the userInterest to set
     * @since JDK 1.8
     */
    public void setUserInterest(Set<String> userInterest) {
        this.userInterest = userInterest;
    }

    /**
     * activityType.
     *
     * @return the activityType
     * @since JDK 1.8
     */
    public Set<String> getActivityType() {
        return activityType;
    }

    /**
     * activityType.
     *
     * @param activityType the activityType to set
     * @since JDK 1.8
     */
    public void setActivityType(Set<String> activityType) {
        this.activityType = activityType;
    }
    public boolean isTrusteeshipOrientPackage() {
        //packageType: 1-人工包，2-自动托管的包(包括自动模式和优投模式)
        return Optional.ofNullable(packageType).orElse(1).equals(2);
    }

    //是否是自动模式
    public boolean isAutoModeOrientPackage() {
        //targetAppLimit:1-不限，2-自动模式，3-优投模式
        return Optional.ofNullable(targetAppLimit).orElse(1).equals(2);
    }
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
