package cn.com.tuia.advert.adxService;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixCommand;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.tuia.advert.fallback.AdxEngineServiceFallbackImpl;
import cn.com.tuia.advert.model.*;
import lombok.Data;

/**
 * adx出券请求接口
 *
 * @author peanut.huang
 * @date 2019/7/4
 * @since JDK 1.8
 */
@AdvancedFeignClient(fallback = AdxEngineServiceFallbackImpl.class)
public interface AdxEngineService {



    /**
     * adx直投发券请求-1.0新接口.
     *
     * @param req  req#adxMediaType 2：ADX直投发券
     * @return
     */
    @FeignHystrixCommand(threadPoolKey = "adx-direct-load-advert")
    @FeignHystrixProperty.FeignHystrixPropertys({
            @FeignHystrixProperty(name= HystrixPropertiesManager.CORE_SIZE, value = "50"),
            @FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "60")
    })
    ObtainAdvertRsp adxDirectLoadAdvertNew(ObtainAdvertReq req);




    /**
     * adx直投发券请求-2.0架构接口
     * adx-engine调用algo算法的架构
     * 和adxDirectLoadAdvertVTwo接口功能一样的 只是 请求对象变了
     * AdxObtainAdvertReq(子类)->继承ObtainAdvertReq(父类)
     * 修复因为ObtainAdvertReq(父类)引用algo相关包参数 导致大盘等系统受影响
     * 2.0架构
     * @param req  req#adxMediaType 2：ADX直投发券
     * @return
     */
    @FeignHystrixCommand(threadPoolKey = "adx-direct-load-advert")
    @FeignHystrixProperty.FeignHystrixPropertys({
            @FeignHystrixProperty(name= HystrixPropertiesManager.CORE_SIZE, value = "50"),
            @FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "60")
    })
    ObtainAdvertRsp adxDirectLoadAdvertAlgo(AdxObtainAdvertReq req);


    /**
     * 查询广告详情接口.
     *
     * @param req the req
     * @return the query advert rsp
     */
    QueryAdvertRsp queryAdvert(QueryAdvertReq req);

    /**
     * @param logReq    请求参数
     * @return          日志补偿是否成功
     */
    @Deprecated
    boolean reLog(AdxLogReq logReq);

    /**
     * 补打发券日志
     *
     * @param req
     * @return
     * @see #reLog(AdxLogReq)
     */
    boolean reLaunchLog(AdxLogReq req);

    /**
     * 补打曝光日志
     *
     * @param req
     * @return
     * @see #reLog(AdxLogReq)
     */
    boolean reShowLog(AdxLogReq req);
}
