package cn.com.tuia.advert.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 广告配置dto
 *
 * @author peanut.huang
 * @date 2019/1/28
 * @since JDK 1.8
 */
public class AdvOrientationDto implements Serializable {

    private static final long serialVersionUID = -8806634002252899651L;

    private String id;
    private Long orientationId;//定向id
    private Long advertId;//广告id
    private Long accountId;
    private Long orderLevel;//广告排序
    private Date levelUpdateTime;//广告排序更新时间
    private Date startDate;//开始投放时间:排期问题
    private Date endDate;//结束投放时间
    private Long cpcPrice;//cpc报价
    private Long cpaPrice;//cpa报价
    private Integer chargeType;//报价类型
    private List<String> regionIds;//投放区域
    private List<String> platform;//投放平台
    private List<String> phoneLevels;//手机价格区间
    private List<Integer> networkTypes;//网络类型
    private List<Integer> operators;//网络运营商
    private Integer ageStart;//年龄区间
    private Integer ageEnd;//年龄区间
    private List<String> bannedTags;//定向标签
    private List<String> advertTags;//广告标签
    private List<String> promoteUrlTags;//落地页标签
    private List<Long> targetApps;//定向媒体
    private List<Long> limitApps; // 限流媒体
    private List<String> allShieldTags;//所有的屏蔽标签，包括定向标签、广告标签、落地页标签
    private List<String> globalShieldTags;//包括广告标签、落地页标签,给全局流量调控用
    private List<Integer> joinNums;//发券顺序
    private List<Long> oldAdvertIds;//老广告id，用于排除已领的
    private String sex;//性别
    private List<String> workState;//工作状态

    private String periodListBytes;//压缩时段信息
    private Long budgetPerDay;//  每日预算
    private String promoteUrl;//落地页url,用于和广告位应用的屏蔽策略匹配
    private Integer packageType;//包的类型 1-人工生成的包 2-智能生成的策略包
    private List<String> bannedAppFlowType;//屏蔽流量类型：1.1:微信-android,1.2:微信-ios;2.1:QQ-android,2.2:QQ-ios;3.1:支付宝-android,3.2:支付宝-ios
    private List<String> appFlowType;//定向流量类型：1:微信;2:QQ;3:支付宝;4:其他
    private List<String> brandName;//手机品牌
    private List<String> appSlotTarget;//定向媒体-广告位
    private List<String> userInterest;//广告行业接受度(行业标签-接受度)：空-不限，0-其他，2-喜欢，1-接受，3-无感，4-排斥,shopping-网购，finance-金融理财， health-健康养生，poker-棋牌游戏，biggame-大型游戏
    private List<String> activityType;//活动类型：1-插件工具、2-活动工具、3-直投页、-1-不限
    /** 权重 **/
    private BigDecimal advertWeight;

    private Integer supportStatus;//是否开启新广告扶持，0-否、1-是

    private Integer targetAppLimit; //1-无限制 2-无定向媒体 3-存在个数上限

    private Integer autoMatch;// 是否开启智能采买 0-否 1-是

    /** 配置包绑定的素材 */
    private Set<Long> materialIds;

    /** subtype 已经选择的调整因子 */
    private Integer subtype;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Long getOrientationId() {
        return orientationId;
    }

    public void setOrientationId(Long orientationId) {
        this.orientationId = orientationId;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Long getOrderLevel() {
        return orderLevel;
    }

    public void setOrderLevel(Long orderLevel) {
        this.orderLevel = orderLevel;
    }

    public Date getLevelUpdateTime() {
        return levelUpdateTime;
    }

    public void setLevelUpdateTime(Date levelUpdateTime) {
        this.levelUpdateTime = levelUpdateTime;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Long getCpcPrice() {
        return cpcPrice;
    }

    public void setCpcPrice(Long cpcPrice) {
        this.cpcPrice = cpcPrice;
    }

    public Long getCpaPrice() {
        return cpaPrice;
    }

    public void setCpaPrice(Long cpaPrice) {
        this.cpaPrice = cpaPrice;
    }

    public Integer getChargeType() {
        return chargeType;
    }

    public void setChargeType(Integer chargeType) {
        this.chargeType = chargeType;
    }

    public List<String> getRegionIds() {
        return regionIds;
    }

    public void setRegionIds(List<String> regionIds) {
        this.regionIds = regionIds;
    }

    public List<String> getPlatform() {
        return platform;
    }

    public void setPlatform(List<String> platform) {
        this.platform = platform;
    }

    public List<String> getPhoneLevels() {
        return phoneLevels;
    }

    public void setPhoneLevels(List<String> phoneLevels) {
        this.phoneLevels = phoneLevels;
    }

    public List<Integer> getNetworkTypes() {
        return networkTypes;
    }

    public void setNetworkTypes(List<Integer> networkTypes) {
        this.networkTypes = networkTypes;
    }

    public List<Integer> getOperators() {
        return operators;
    }

    public void setOperators(List<Integer> operators) {
        this.operators = operators;
    }

    public Integer getAgeStart() {
        return ageStart;
    }

    public void setAgeStart(Integer ageStart) {
        this.ageStart = ageStart;
    }

    public Integer getAgeEnd() {
        return ageEnd;
    }

    public void setAgeEnd(Integer ageEnd) {
        this.ageEnd = ageEnd;
    }

    public List<String> getBannedTags() {
        return bannedTags;
    }

    public void setBannedTags(List<String> bannedTags) {
        this.bannedTags = bannedTags;
    }

    public List<String> getAdvertTags() {
        return advertTags;
    }

    public void setAdvertTags(List<String> advertTags) {
        this.advertTags = advertTags;
    }

    public List<String> getPromoteUrlTags() {
        return promoteUrlTags;
    }

    public void setPromoteUrlTags(List<String> promoteUrlTags) {
        this.promoteUrlTags = promoteUrlTags;
    }

    public List<Long> getTargetApps() {
        return targetApps;
    }

    public void setTargetApps(List<Long> targetApps) {
        this.targetApps = targetApps;
    }

    public List<String> getAllShieldTags() {
        return allShieldTags;
    }

    public void setAllShieldTags(List<String> allShieldTags) {
        this.allShieldTags = allShieldTags;
    }

    public List<String> getGlobalShieldTags() {
        return globalShieldTags;
    }

    public void setGlobalShieldTags(List<String> globalShieldTags) {
        this.globalShieldTags = globalShieldTags;
    }

    public List<Integer> getJoinNums() {
        return joinNums;
    }

    public void setJoinNums(List<Integer> joinNums) {
        this.joinNums = joinNums;
    }

    public List<Long> getOldAdvertIds() {
        return oldAdvertIds;
    }

    public void setOldAdvertIds(List<Long> oldAdvertIds) {
        this.oldAdvertIds = oldAdvertIds;
    }

    public String getSex() {
        return sex;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public List<String> getWorkState() {
        return workState;
    }

    public void setWorkState(List<String> workState) {
        this.workState = workState;
    }

    public String getPeriodListBytes() {
        return periodListBytes;
    }

    public void setPeriodListBytes(String periodListBytes) {
        this.periodListBytes = periodListBytes;
    }

    public Long getBudgetPerDay() {
        return budgetPerDay;
    }

    public void setBudgetPerDay(Long budgetPerDay) {
        this.budgetPerDay = budgetPerDay;
    }

    public String getPromoteUrl() {
        return promoteUrl;
    }

    public void setPromoteUrl(String promoteUrl) {
        this.promoteUrl = promoteUrl;
    }

    public Integer getPackageType() {
        return packageType;
    }

    public void setPackageType(Integer packageType) {
        this.packageType = packageType;
    }

    public List<String> getBannedAppFlowType() {
        return bannedAppFlowType;
    }

    public void setBannedAppFlowType(List<String> bannedAppFlowType) {
        this.bannedAppFlowType = bannedAppFlowType;
    }

    public List<String> getAppFlowType() {
        return appFlowType;
    }

    public void setAppFlowType(List<String> appFlowType) {
        this.appFlowType = appFlowType;
    }

    public List<String> getBrandName() {
        return brandName;
    }

    public void setBrandName(List<String> brandName) {
        this.brandName = brandName;
    }

    public List<String> getAppSlotTarget() {
        return appSlotTarget;
    }

    public void setAppSlotTarget(List<String> appSlotTarget) {
        this.appSlotTarget = appSlotTarget;
    }

    public List<String> getUserInterest() {
        return userInterest;
    }

    public void setUserInterest(List<String> userInterest) {
        this.userInterest = userInterest;
    }

    public List<String> getActivityType() {
        return activityType;
    }

    public void setActivityType(List<String> activityType) {
        this.activityType = activityType;
    }

    public BigDecimal getAdvertWeight() {
        return advertWeight;
    }

    public void setAdvertWeight(BigDecimal advertWeight) {
        this.advertWeight = advertWeight;
    }

    public Integer getSupportStatus() {
        return supportStatus;
    }

    public void setSupportStatus(Integer supportStatus) {
        this.supportStatus = supportStatus;
    }

    public Integer getTargetAppLimit() {
        return targetAppLimit;
    }

    public void setTargetAppLimit(Integer targetAppLimit) {
        this.targetAppLimit = targetAppLimit;
    }

    public Integer getAutoMatch() {
        return autoMatch;
    }

    public void setAutoMatch(Integer autoMatch) {
        this.autoMatch = autoMatch;
    }

    public Set<Long> getMaterialIds() {
        return materialIds;
    }

    public void setMaterialIds(Set<Long> materialIds) {
        this.materialIds = materialIds;
    }

    public Integer getSubtype() {
        return subtype;
    }

    public void setSubtype(Integer subtype) {
        this.subtype = subtype;
    }

    public List<Long> getLimitApps() {
        return limitApps;
    }

    public void setLimitApps(List<Long> limitApps) {
        this.limitApps = limitApps;
    }
}
