package cn.com.tuia.advert.enums;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * 
 * ClassName: CVRTypeEnum <br/>
 * Function: 传给nezha的CVRType. <br/>
 * date: 2019年1月25日 下午5:29:56 <br/>
 *
 * @author chencheng
 * @version 
 * @since JDK 1.8
 */
public enum CVRTypeEnum {

    CVR(0,"cvr"),
    START(2,"激活"),
    REGISTE(3,"注册"),
    ACTIVITY(4, "激活"),
    LOGIN(5, "登录"),
    PAY(6, "付费"),
    ENTRY(7, "进件"),
    FINISH(8, "完件");

    private Integer cvrType;

    private String  desc;

    CVRTypeEnum(Integer cvrType, String desc) {
        this.cvrType = cvrType;
        this.desc = desc;
    }

    private static Map<Integer, CVRTypeEnum> enumMap = Maps.newHashMap();

    static {
        for (CVRTypeEnum it : CVRTypeEnum.values()) {
            enumMap.put(it.getCvrType(), it);
        }
    }

    public static CVRTypeEnum getByCvrType(Integer cvrType) {
        return enumMap.get(cvrType);
    }
    
    /**
     * 
     * changeSubtypeToCVRType:(AdvertSubtypeEnum 转 CVRTypeEnum). <br/>
     *
     * @author chencheng
     * @param subtype
     * @return
     * @since JDK 1.8
     */
    public static Integer changeSubtypeToCVRType(Integer subtype) {
        AdvertSubtypeEnum enumType = AdvertSubtypeEnum.getBySubtype(subtype);
        if(enumType == null){
            return CVRTypeEnum.CVR.getCvrType();
        }
        switch (enumType) {
            case CVR:
            case SIGN_FOR:
                return CVRTypeEnum.CVR.getCvrType();
            default:
                CVRTypeEnum cvrTypeEnum = enumMap.get(subtype);
                if (cvrTypeEnum != null) {
                    return cvrTypeEnum.getCvrType();
                }
                return CVRTypeEnum.CVR.getCvrType();
        }
        
    }
    
    
    /**
     * cvrType.
     *
     * @return the cvrType
     * @since JDK 1.8
     */
    public Integer getCvrType() {
        return cvrType;
    }

    /**
     * cvrType.
     *
     * @param cvrType the cvrType to set
     * @since JDK 1.8
     */
    public void setCvrType(Integer cvrType) {
        this.cvrType = cvrType;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
    
}
